/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

public class BufferOrEvent {
    private final Buffer buffer;
    private final AbstractEvent event;
    private boolean moreAvailable;
    private int channelIndex;

    BufferOrEvent(Buffer buffer, int channelIndex, boolean moreAvailable) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.event = null;
        this.channelIndex = channelIndex;
        this.moreAvailable = moreAvailable;
    }

    BufferOrEvent(AbstractEvent event, int channelIndex, boolean moreAvailable) {
        this.buffer = null;
        this.event = (AbstractEvent)Preconditions.checkNotNull((Object)event);
        this.channelIndex = channelIndex;
        this.moreAvailable = moreAvailable;
    }

    public BufferOrEvent(Buffer buffer, int channelIndex) {
        this(buffer, channelIndex, true);
    }

    public BufferOrEvent(AbstractEvent event, int channelIndex) {
        this(event, channelIndex, true);
    }

    public boolean isBuffer() {
        return this.buffer != null;
    }

    public boolean isEvent() {
        return this.event != null;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public AbstractEvent getEvent() {
        return this.event;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0);
        this.channelIndex = channelIndex;
    }

    boolean moreAvailable() {
        return this.moreAvailable;
    }

    public String toString() {
        return String.format("BufferOrEvent [%s, channelIndex = %d]", this.isBuffer() ? this.buffer : this.event, this.channelIndex);
    }

    public void setMoreAvailable(boolean moreAvailable) {
        this.moreAvailable = moreAvailable;
    }
}

