/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;

public enum HighAvailabilityMode {
    NONE,
    ZOOKEEPER;


    public static HighAvailabilityMode fromConfig(Configuration config) {
        String haMode = config.getValue(HighAvailabilityOptions.HA_MODE);
        if (haMode == null) {
            return NONE;
        }
        if (haMode.equalsIgnoreCase("standalone")) {
            return NONE;
        }
        return HighAvailabilityMode.valueOf(haMode.toUpperCase());
    }

    public static boolean isHighAvailabilityModeActivated(Configuration configuration) {
        HighAvailabilityMode mode = HighAvailabilityMode.fromConfig(configuration);
        switch (mode) {
            case NONE: {
                return false;
            }
            case ZOOKEEPER: {
                return true;
            }
        }
        return false;
    }
}

