/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractSubtaskAttemptHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class SubtaskExecutionAttemptDetailsHandler
extends AbstractSubtaskAttemptHandler<SubtaskExecutionAttemptDetailsInfo, SubtaskAttemptMessageParameters>
implements JsonArchivist {
    private final MetricFetcher<?> metricFetcher;

    public SubtaskExecutionAttemptDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, SubtaskExecutionAttemptDetailsInfo, SubtaskAttemptMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher<?> metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull(metricFetcher);
    }

    @Override
    protected SubtaskExecutionAttemptDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody, SubtaskAttemptMessageParameters> request, AccessExecution execution) throws RestHandlerException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        return SubtaskExecutionAttemptDetailsHandler.createDetailsInfo(execution, jobID, jobVertexID, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(16);
        for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
            for (AccessExecutionVertex subtask : accessExecutionJobVertex.getTaskVertices()) {
                SubtaskExecutionAttemptDetailsInfo curAttemptJson = SubtaskExecutionAttemptDetailsHandler.createDetailsInfo(subtask.getCurrentExecutionAttempt(), graph.getJobID(), accessExecutionJobVertex.getJobVertexId(), null);
                String curAttemptPath = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtaskindex", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(subtask.getCurrentExecutionAttempt().getAttemptNumber()));
                archive.add(new ArchivedJson(curAttemptPath, curAttemptJson));
                for (int x = 0; x < subtask.getCurrentExecutionAttempt().getAttemptNumber(); ++x) {
                    AccessExecution attempt = subtask.getPriorExecutionAttempt(x);
                    SubtaskExecutionAttemptDetailsInfo json = SubtaskExecutionAttemptDetailsHandler.createDetailsInfo(attempt, graph.getJobID(), accessExecutionJobVertex.getJobVertexId(), null);
                    String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtaskindex", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(attempt.getAttemptNumber()));
                    archive.add(new ArchivedJson(path, json));
                }
            }
        }
        return archive;
    }

    private static SubtaskExecutionAttemptDetailsInfo createDetailsInfo(AccessExecution execution, JobID jobID, JobVertexID jobVertexID, @Nullable MetricFetcher<?> metricFetcher) {
        MutableIOMetrics ioMetrics = new MutableIOMetrics();
        ioMetrics.addIOMetrics(execution, metricFetcher, jobID.toString(), jobVertexID.toString());
        return SubtaskExecutionAttemptDetailsInfo.create(execution, ioMetrics);
    }
}

