/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexMetricsMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexMetricsHandler
extends AbstractMetricsHandler<JobVertexMetricsMessageParameters> {
    public JobVertexMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, JobVertexMetricsHeaders.getInstance(), metricFetcher);
    }

    @Override
    protected MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody, JobVertexMetricsMessageParameters> request, MetricStore metricStore) {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID vertexId = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        return metricStore.getTaskMetricStore(jobId.toString(), vertexId.toString());
    }
}

