/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractSubtaskRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.RequestHandlerException;
import org.apache.flink.util.FlinkException;

public abstract class AbstractSubtaskAttemptRequestHandler
extends AbstractSubtaskRequestHandler {
    public AbstractSubtaskAttemptRequestHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionVertex vertex, Map<String, String> params) {
        int attempt;
        String attemptNumberString = params.get("attempt");
        if (attemptNumberString == null) {
            return FutureUtils.completedExceptionally(new FlinkException("Attempt number parameter missing"));
        }
        try {
            attempt = Integer.parseInt(attemptNumberString);
        }
        catch (NumberFormatException e) {
            return FutureUtils.completedExceptionally(new FlinkException("Invalid attempt number parameter"));
        }
        AccessExecution currentAttempt = vertex.getCurrentExecutionAttempt();
        if (attempt == currentAttempt.getAttemptNumber()) {
            return this.handleRequest(currentAttempt, params);
        }
        if (attempt >= 0 && attempt < currentAttempt.getAttemptNumber()) {
            AccessExecution exec = vertex.getPriorExecutionAttempt(attempt);
            if (exec != null) {
                return this.handleRequest(exec, params);
            }
            return FutureUtils.completedExceptionally(new RequestHandlerException("Execution for attempt " + attempt + " has already been deleted."));
        }
        return FutureUtils.completedExceptionally(new FlinkException("Attempt does not exist: " + attempt));
    }

    public abstract CompletableFuture<String> handleRequest(AccessExecution var1, Map<String, String> var2);
}

