/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class ClusterConfigHandler
extends AbstractJsonRequestHandler {
    private final String clusterConfigJson;

    public ClusterConfigHandler(Executor executor, Configuration config) {
        super(executor);
        Preconditions.checkNotNull((Object)config);
        this.clusterConfigJson = ClusterConfigHandler.createConfigJson(config);
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/jobmanager/config"};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.completedFuture(this.clusterConfigJson);
    }

    private static String createConfigJson(Configuration config) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
            gen.writeStartArray();
            for (String key : config.keySet()) {
                gen.writeStartObject();
                gen.writeStringField("key", key);
                String value = config.getString(key, null);
                if (value != null && GlobalConfiguration.isSensitive((String)key)) {
                    value = "******";
                }
                gen.writeStringField("value", value);
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new CompletionException(new FlinkException("Could not write configuration.", (Throwable)e));
        }
    }
}

