/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class SubtasksTimesHandler
extends AbstractJobVertexRequestHandler {
    private static final String SUBTASK_TIMES_REST_PATH = "/jobs/:jobid/vertices/:vertexid/subtasktimes";

    public SubtasksTimesHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{SUBTASK_TIMES_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionJobVertex jobVertex, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return SubtasksTimesHandler.createSubtaskTimesJson(jobVertex);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not write subtask time json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createSubtaskTimesJson(AccessExecutionJobVertex jobVertex) throws IOException {
        long now = System.currentTimeMillis();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeStringField("name", jobVertex.getName());
        gen.writeNumberField("now", now);
        gen.writeArrayFieldStart("subtasks");
        int num = 0;
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            long[] timestamps = vertex.getCurrentExecutionAttempt().getStateTimestamps();
            ExecutionState status = vertex.getExecutionState();
            long scheduledTime = timestamps[ExecutionState.SCHEDULED.ordinal()];
            long start2 = scheduledTime > 0L ? scheduledTime : -1L;
            long end = status.isTerminal() ? timestamps[status.ordinal()] : now;
            long duration = start2 >= 0L ? end - start2 : -1L;
            gen.writeStartObject();
            gen.writeNumberField("subtask", num++);
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname();
            gen.writeStringField("host", locationString);
            gen.writeNumberField("duration", duration);
            gen.writeObjectFieldStart("timestamps");
            for (ExecutionState state : ExecutionState.values()) {
                gen.writeNumberField(state.name(), timestamps[state.ordinal()]);
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class SubtasksTimesJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>();
            for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
                String json = SubtasksTimesHandler.createSubtaskTimesJson(accessExecutionJobVertex);
                String path = SubtasksTimesHandler.SUBTASK_TIMES_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
                archive.add(new ArchivedJson(path, json));
            }
            return archive;
        }
    }
}

