/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.util.UnionIterator;

public class AggregatingSubtasksMetricsHandler
extends AbstractAggregatingMetricsHandler {
    public AggregatingSubtasksMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor, fetcher);
    }

    @Override
    protected Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, Map<String, String> pathParameters, Map<String, String> queryParameters) {
        String jobID = pathParameters.get("jobid");
        String taskID = pathParameters.get("vertexid");
        if (jobID == null) {
            return Collections.emptyList();
        }
        if (taskID == null) {
            return Collections.emptyList();
        }
        String subtasksList = queryParameters.get("subtasks");
        if (subtasksList == null || subtasksList.isEmpty()) {
            return store.getTaskMetricStore(jobID, taskID).getAllSubtaskMetricStores();
        }
        Iterable<Integer> subtasks = this.getIntegerRangeFromString(subtasksList);
        ArrayList<MetricStore.ComponentMetricStore> subtaskStores = new ArrayList<MetricStore.ComponentMetricStore>();
        for (int subtask : subtasks) {
            subtaskStores.add(store.getSubtaskMetricStore(jobID, taskID, subtask));
        }
        return subtaskStores;
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/jobs/:jobid/vertices/:vertexid/subtasks/metrics"};
    }

    private Iterable<Integer> getIntegerRangeFromString(String rangeDefinition) {
        String[] ranges = rangeDefinition.trim().split(",");
        UnionIterator iterators = new UnionIterator();
        for (String rawRange : ranges) {
            try {
                Iterator<Integer> rangeIterator;
                String range = rawRange.trim();
                int dashIdx = range.indexOf(45);
                if (dashIdx == -1) {
                    rangeIterator = Collections.singleton(Integer.valueOf(range)).iterator();
                } else {
                    final int start2 = Integer.valueOf(range.substring(0, dashIdx));
                    final int end = Integer.valueOf(range.substring(dashIdx + 1, range.length()));
                    rangeIterator = new Iterator<Integer>(){
                        int i;
                        {
                            this.i = start2;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i <= end;
                        }

                        @Override
                        public Integer next() {
                            if (this.hasNext()) {
                                return this.i++;
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Remove not supported");
                        }
                    };
                }
                iterators.add(rangeIterator);
            }
            catch (NumberFormatException nfe) {
                this.log.warn("Invalid value {} specified for integer range. Not a number.", (Object)rawRange, (Object)nfe);
            }
        }
        return iterators;
    }
}

