/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;

public class SubtaskMetricsHandler
extends AbstractMetricsHandler {
    private static final String SUBTASK_METRICS_REST_PATH = "/jobs/:jobid/vertices/:vertexid/subtasks/:subtasknum/metrics";

    public SubtaskMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor, fetcher);
    }

    @Override
    public String[] getPaths() {
        return new String[]{SUBTASK_METRICS_REST_PATH};
    }

    @Override
    protected Map<String, String> getMapFor(Map<String, String> pathParams, MetricStore metrics) {
        int subtaskNum;
        String subtaskNumString = pathParams.get("subtasknum");
        try {
            subtaskNum = Integer.valueOf(subtaskNumString);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        MetricStore.ComponentMetricStore subtask = metrics.getSubtaskMetricStore(pathParams.get("jobid"), pathParams.get("vertexid"), subtaskNum);
        return subtask != null ? subtask.metrics : null;
    }
}

