/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.util.Preconditions;

public class KeyedBackendSerializationProxy<K>
extends VersionedIOReadableWritable {
    public static final int VERSION = 5;
    private boolean usingKeyGroupCompression;
    private boolean isSerializerPresenceRequired;
    private TypeSerializer<K> keySerializer;
    private TypeSerializerConfigSnapshot keySerializerConfigSnapshot;
    private List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public KeyedBackendSerializationProxy(ClassLoader userCodeClassLoader, boolean isSerializerPresenceRequired) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.isSerializerPresenceRequired = isSerializerPresenceRequired;
    }

    public KeyedBackendSerializationProxy(TypeSerializer<K> keySerializer, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, boolean compression) {
        this.usingKeyGroupCompression = compression;
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)keySerializer.snapshotConfiguration());
        Preconditions.checkNotNull(stateMetaInfoSnapshots);
        Preconditions.checkArgument((stateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
        this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
    }

    public List<StateMetaInfoSnapshot> getStateMetaInfoSnapshots() {
        return this.stateMetaInfoSnapshots;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializerConfigSnapshot getKeySerializerConfigSnapshot() {
        return this.keySerializerConfigSnapshot;
    }

    public boolean isUsingKeyGroupCompression() {
        return this.usingKeyGroupCompression;
    }

    public int getVersion() {
        return 5;
    }

    public int[] getCompatibleVersions() {
        return new int[]{5, 4, 3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeBoolean(this.usingKeyGroupCompression);
        TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Collections.singletonList(new Tuple2(this.keySerializer, (Object)this.keySerializerConfigSnapshot)));
        out.writeShort(this.stateMetaInfoSnapshots.size());
        for (StateMetaInfoSnapshot metaInfoSnapshot : this.stateMetaInfoSnapshots) {
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(metaInfoSnapshot, out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int readVersion = this.getReadVersion();
        this.usingKeyGroupCompression = readVersion >= 4 ? in.readBoolean() : false;
        if (readVersion >= 3) {
            Tuple2 keySerializerAndConfig = (Tuple2)TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader).get(0);
            this.keySerializer = (TypeSerializer)keySerializerAndConfig.f0;
            this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)keySerializerAndConfig.f1;
        } else {
            this.keySerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)in, (ClassLoader)this.userCodeClassLoader, (boolean)true);
            this.keySerializerConfigSnapshot = null;
        }
        if (this.isSerializerPresenceRequired) {
            this.checkSerializerPresence(this.keySerializer);
        }
        int metaInfoVersion = readVersion > 4 ? 5 : readVersion;
        StateMetaInfoReader stateMetaInfoReader = StateMetaInfoSnapshotReadersWriters.getReader(metaInfoVersion, StateMetaInfoSnapshotReadersWriters.StateTypeHint.KEYED_STATE);
        int numKvStates = in.readShort();
        this.stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            StateMetaInfoSnapshot snapshot = stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader);
            if (this.isSerializerPresenceRequired) {
                this.checkSerializerPresence(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER));
                this.checkSerializerPresence(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER));
            }
            this.stateMetaInfoSnapshots.add(snapshot);
        }
    }

    private void checkSerializerPresence(TypeSerializer<?> serializer) throws IOException {
        if (serializer instanceof UnloadableDummyTypeSerializer) {
            throw new IOException("Unable to restore keyed state, because a previous serializer of the keyed state is not present The serializer could have been removed from the classpath,  or its implementation have changed and could not be loaded. This is a temporary restriction that will be fixed in future versions.");
        }
    }
}

