/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.util.Preconditions;

public class OperatorBackendSerializationProxy
extends VersionedIOReadableWritable {
    public static final int VERSION = 4;
    private List<StateMetaInfoSnapshot> operatorStateMetaInfoSnapshots;
    private List<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public OperatorBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public OperatorBackendSerializationProxy(List<StateMetaInfoSnapshot> operatorStateMetaInfoSnapshots, List<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots) {
        this.operatorStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(operatorStateMetaInfoSnapshots);
        this.broadcastStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(broadcastStateMetaInfoSnapshots);
        Preconditions.checkArgument((operatorStateMetaInfoSnapshots.size() <= Short.MAX_VALUE && broadcastStateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public int getVersion() {
        return 4;
    }

    public int[] getCompatibleVersions() {
        return new int[]{4, 3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.writeStateMetaInfoSnapshots(this.operatorStateMetaInfoSnapshots, out);
        this.writeStateMetaInfoSnapshots(this.broadcastStateMetaInfoSnapshots, out);
    }

    private void writeStateMetaInfoSnapshots(List<StateMetaInfoSnapshot> snapshots, DataOutputView out) throws IOException {
        out.writeShort(snapshots.size());
        for (StateMetaInfoSnapshot state : snapshots) {
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(state, out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int proxyReadVersion = this.getReadVersion();
        int metaInfoReadVersion = proxyReadVersion > 3 ? 5 : proxyReadVersion;
        StateMetaInfoReader stateMetaInfoReader = StateMetaInfoSnapshotReadersWriters.getReader(metaInfoReadVersion, StateMetaInfoSnapshotReadersWriters.StateTypeHint.OPERATOR_STATE);
        int numOperatorStates = in.readShort();
        this.operatorStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numOperatorStates);
        for (int i = 0; i < numOperatorStates; ++i) {
            this.operatorStateMetaInfoSnapshots.add(stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader));
        }
        if (proxyReadVersion >= 3) {
            int numBroadcastStates = in.readShort();
            this.broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numBroadcastStates);
            for (int i = 0; i < numBroadcastStates; ++i) {
                this.broadcastStateMetaInfoSnapshots.add(stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader));
            }
        } else {
            this.broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        }
    }

    public List<StateMetaInfoSnapshot> getOperatorStateMetaInfoSnapshots() {
        return this.operatorStateMetaInfoSnapshots;
    }

    public List<StateMetaInfoSnapshot> getBroadcastStateMetaInfoSnapshots() {
        return this.broadcastStateMetaInfoSnapshots;
    }
}

