/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@FunctionalInterface
public interface StateSnapshotTransformer<T> {
    @Nullable
    public T filterOrTransform(@Nullable T var1);

    public static interface StateSnapshotTransformFactory<T> {
        public static final StateSnapshotTransformFactory<?> NO_TRANSFORM = StateSnapshotTransformFactory.createNoTransform();

        public static <T> StateSnapshotTransformFactory<T> noTransform() {
            return NO_TRANSFORM;
        }

        public static <T> StateSnapshotTransformFactory<T> createNoTransform() {
            return new StateSnapshotTransformFactory<T>(){

                @Override
                public Optional<StateSnapshotTransformer<T>> createForDeserializedState() {
                    return Optional.empty();
                }

                @Override
                public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
                    return Optional.empty();
                }
            };
        }

        public Optional<StateSnapshotTransformer<T>> createForDeserializedState();

        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState();
    }

    public static class MapStateSnapshotTransformer<K, V>
    implements StateSnapshotTransformer<Map<K, V>> {
        private final StateSnapshotTransformer<V> entryValueTransformer;

        public MapStateSnapshotTransformer(StateSnapshotTransformer<V> entryValueTransformer) {
            this.entryValueTransformer = entryValueTransformer;
        }

        @Override
        @Nullable
        public Map<K, V> filterOrTransform(@Nullable Map<K, V> map) {
            if (map == null) {
                return null;
            }
            HashMap<K, V> transformedMap = new HashMap<K, V>();
            boolean anyChange = false;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                V transformedValue = this.entryValueTransformer.filterOrTransform(entry.getValue());
                if (transformedValue != null) {
                    transformedMap.put(entry.getKey(), transformedValue);
                }
                anyChange |= transformedValue == null || !Objects.equals(entry.getValue(), transformedValue);
            }
            return anyChange ? (transformedMap.isEmpty() ? null : transformedMap) : map;
        }
    }

    public static class ListStateSnapshotTransformer<T>
    implements StateSnapshotTransformer<List<T>> {
        private final StateSnapshotTransformer<T> entryValueTransformer;
        private final CollectionStateSnapshotTransformer.TransformStrategy transformStrategy;

        public ListStateSnapshotTransformer(StateSnapshotTransformer<T> entryValueTransformer) {
            this.entryValueTransformer = entryValueTransformer;
            this.transformStrategy = entryValueTransformer instanceof CollectionStateSnapshotTransformer ? ((CollectionStateSnapshotTransformer)entryValueTransformer).getFilterStrategy() : CollectionStateSnapshotTransformer.TransformStrategy.TRANSFORM_ALL;
        }

        @Override
        @Nullable
        public List<T> filterOrTransform(@Nullable List<T> list) {
            if (list == null) {
                return null;
            }
            List<T> transformedList = new ArrayList<T>();
            boolean anyChange = false;
            for (int i = 0; i < list.size(); ++i) {
                T entry = list.get(i);
                T transformedEntry = this.entryValueTransformer.filterOrTransform(entry);
                if (transformedEntry != null) {
                    if (this.transformStrategy == CollectionStateSnapshotTransformer.TransformStrategy.STOP_ON_FIRST_INCLUDED) {
                        transformedList = list.subList(i, list.size());
                        anyChange = i > 0;
                        break;
                    }
                    transformedList.add(transformedEntry);
                }
                anyChange |= transformedEntry == null || !Objects.equals(entry, transformedEntry);
            }
            transformedList = anyChange ? transformedList : list;
            return transformedList.isEmpty() ? null : transformedList;
        }
    }

    public static interface CollectionStateSnapshotTransformer<T>
    extends StateSnapshotTransformer<T> {
        default public TransformStrategy getFilterStrategy() {
            return TransformStrategy.TRANSFORM_ALL;
        }

        public static enum TransformStrategy {
            TRANSFORM_ALL,
            STOP_ON_FIRST_INCLUDED;

        }
    }
}

