/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.LegacySchedulerFactory;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;

final class SchedulerNGFactoryFactory {
    private SchedulerNGFactoryFactory() {
    }

    static SchedulerNGFactory createSchedulerNGFactory(Configuration configuration, RestartStrategyFactory restartStrategyFactory) {
        String schedulerName;
        switch (schedulerName = configuration.getString(JobManagerOptions.SCHEDULER)) {
            case "legacy": {
                return new LegacySchedulerFactory(restartStrategyFactory);
            }
            case "ng": {
                return new DefaultSchedulerFactory();
            }
        }
        throw new IllegalArgumentException(String.format("Illegal value [%s] for config option [%s]", schedulerName, JobManagerOptions.SCHEDULER.key()));
    }
}

