/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceDiedException;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAvailabilityListener;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instance
implements SlotOwner {
    private static final Logger LOG = LoggerFactory.getLogger(Instance.class);
    private final Object instanceLock = new Object();
    private final TaskManagerGateway taskManagerGateway;
    private final TaskManagerLocation location;
    private final HardwareDescription resources;
    private final InstanceID instanceId;
    private final int numberOfSlots;
    private final Queue<Integer> availableSlots;
    private final Set<Slot> allocatedSlots = new HashSet<Slot>();
    private SlotAvailabilityListener slotAvailabilityListener;
    private volatile long lastReceivedHeartBeat = System.currentTimeMillis();
    private volatile boolean isDead;

    public Instance(TaskManagerGateway taskManagerGateway, TaskManagerLocation location, InstanceID id, HardwareDescription resources, int numberOfSlots) {
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
        this.location = (TaskManagerLocation)Preconditions.checkNotNull((Object)location);
        this.instanceId = (InstanceID)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.resources = (HardwareDescription)Preconditions.checkNotNull((Object)resources);
        this.numberOfSlots = numberOfSlots;
        this.availableSlots = new ArrayDeque<Integer>(numberOfSlots);
        for (int i = 0; i < numberOfSlots; ++i) {
            this.availableSlots.add(i);
        }
    }

    public ResourceID getTaskManagerID() {
        return this.location.getResourceID();
    }

    public InstanceID getId() {
        return this.instanceId;
    }

    public HardwareDescription getResources() {
        return this.resources;
    }

    public int getTotalNumberOfSlots() {
        return this.numberOfSlots;
    }

    public boolean isAlive() {
        return !this.isDead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDead() {
        ArrayList<Slot> slots;
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                return;
            }
            this.isDead = true;
            this.slotAvailabilityListener = null;
            slots = new ArrayList<Slot>(this.allocatedSlots);
            this.allocatedSlots.clear();
            this.availableSlots.clear();
        }
        FlinkException cause = new FlinkException("Instance " + this + " has been marked as dead.");
        for (Slot slot : slots) {
            slot.releaseSlot(cause);
        }
    }

    public long getLastHeartBeat() {
        return this.lastReceivedHeartBeat;
    }

    public void reportHeartBeat() {
        this.lastReceivedHeartBeat = System.currentTimeMillis();
    }

    public boolean isStillAlive(long now, long cleanUpInterval) {
        return this.lastReceivedHeartBeat + cleanUpInterval > now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot allocateSimpleSlot() throws InstanceDiedException {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                throw new InstanceDiedException(this);
            }
            Integer nextSlot = this.availableSlots.poll();
            if (nextSlot == null) {
                return null;
            }
            SimpleSlot slot = new SimpleSlot(this, this.location, (int)nextSlot, this.taskManagerGateway);
            this.allocatedSlots.add(slot);
            return slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedSlot allocateSharedSlot(SlotSharingGroupAssignment sharingGroupAssignment) throws InstanceDiedException {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                throw new InstanceDiedException(this);
            }
            Integer nextSlot = this.availableSlots.poll();
            if (nextSlot == null) {
                return null;
            }
            SharedSlot slot = new SharedSlot(this, this.location, (int)nextSlot, this.taskManagerGateway, sharingGroupAssignment);
            this.allocatedSlots.add(slot);
            return slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnLogicalSlot(LogicalSlot logicalSlot) {
        Preconditions.checkNotNull((Object)logicalSlot);
        Preconditions.checkArgument((boolean)(logicalSlot instanceof Slot));
        Slot slot = (Slot)((Object)logicalSlot);
        Preconditions.checkArgument((!slot.isAlive() ? 1 : 0) != 0, (Object)"slot is still alive");
        Preconditions.checkArgument((slot.getOwner() == this ? 1 : 0) != 0, (Object)"slot belongs to the wrong TaskManager.");
        if (slot.markReleased()) {
            LOG.debug("Return allocated slot {}.", (Object)slot);
            Object object = this.instanceLock;
            synchronized (object) {
                if (this.isDead) {
                    return;
                }
                if (this.allocatedSlots.remove(slot)) {
                    this.availableSlots.add(slot.getSlotNumber());
                    if (this.slotAvailabilityListener != null) {
                        this.slotAvailabilityListener.newSlotAvailable(this);
                    }
                } else {
                    throw new IllegalArgumentException("Slot was not allocated from this TaskManager.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAndReleaseAllSlots() {
        ArrayList<Slot> copy;
        Object object = this.instanceLock;
        synchronized (object) {
            copy = new ArrayList<Slot>(this.allocatedSlots);
        }
        FlinkException cause = new FlinkException("Cancel and release all slots of instance " + this + '.');
        for (Slot slot : copy) {
            slot.releaseSlot(cause);
        }
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.location;
    }

    public int getNumberOfAvailableSlots() {
        return this.availableSlots.size();
    }

    public int getNumberOfAllocatedSlots() {
        return this.allocatedSlots.size();
    }

    public boolean hasResourcesAvailable() {
        return !this.isDead && this.getNumberOfAvailableSlots() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotAvailabilityListener(SlotAvailabilityListener slotAvailabilityListener) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.slotAvailabilityListener != null) {
                throw new IllegalStateException("Instance has already a slot listener.");
            }
            this.slotAvailabilityListener = slotAvailabilityListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlotListener() {
        Object object = this.instanceLock;
        synchronized (object) {
            this.slotAvailabilityListener = null;
        }
    }

    public String toString() {
        return String.format("%s @ %s - %d slots - URL: %s", new Object[]{this.instanceId, this.location.getHostname(), this.numberOfSlots, this.taskManagerGateway != null ? this.taskManagerGateway.getAddress() : "No instance gateway"});
    }
}

