/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelManagerImpl
implements FileChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannelManagerImpl.class);
    private final File[] paths;
    private final Random random;
    private volatile int nextPath;

    public FileChannelManagerImpl(String[] tempDirs, String prefix) {
        Preconditions.checkNotNull((Object)tempDirs, (String)"The temporary directories must not be null.");
        Preconditions.checkArgument((tempDirs.length > 0 ? 1 : 0) != 0, (Object)"The temporary directories must not be empty.");
        this.random = new Random();
        this.nextPath = 0;
        this.paths = FileChannelManagerImpl.createFiles(tempDirs, prefix);
    }

    private static File[] createFiles(String[] tempDirs, String prefix) {
        File[] files = new File[tempDirs.length];
        for (int i = 0; i < tempDirs.length; ++i) {
            File baseDir = new File(tempDirs[i]);
            String subfolder = String.format("flink-%s-%s", prefix, UUID.randomUUID().toString());
            File storageDir = new File(baseDir, subfolder);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                throw new RuntimeException("Could not create storage directory for FileChannelManager: " + storageDir.getAbsolutePath());
            }
            files[i] = storageDir;
            LOG.info("FileChannelManager uses directory {} for spill files.", (Object)storageDir.getAbsolutePath());
        }
        return files;
    }

    @Override
    public FileIOChannel.ID createChannel() {
        int num = this.getNextPathNum();
        return new FileIOChannel.ID(this.paths[num], num, this.random);
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        return new FileIOChannel.Enumerator(this.paths, this.random);
    }

    @Override
    public File[] getPaths() {
        return Arrays.copyOf(this.paths, this.paths.length);
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll((Iterable)Arrays.stream(this.paths).filter(File::exists).map(FileChannelManagerImpl::getFileCloser).collect(Collectors.toList()));
    }

    private static AutoCloseable getFileCloser(File path) {
        return () -> {
            try {
                FileUtils.deleteDirectory((File)path);
                LOG.info("FileChannelManager removed spill file directory {}", (Object)path.getAbsolutePath());
            }
            catch (IOException e) {
                String errorMessage = String.format("FileChannelManager failed to properly clean up temp file directory: %s", path);
                throw new IOException(errorMessage, e);
            }
        };
    }

    private int getNextPathNum() {
        int next = this.nextPath;
        int newNext = next + 1;
        this.nextPath = newNext >= this.paths.length ? 0 : newNext;
        return next;
    }
}

