/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;
import org.apache.flink.util.Preconditions;

public class TriggerCheckpoint
extends AbstractCheckpointMessage {
    private static final long serialVersionUID = 2094094662279578953L;
    private final long timestamp;
    private final CheckpointOptions checkpointOptions;

    public TriggerCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, long timestamp, CheckpointOptions checkpointOptions) {
        super(job, taskExecutionId, checkpointId);
        this.timestamp = timestamp;
        this.checkpointOptions = (CheckpointOptions)Preconditions.checkNotNull((Object)checkpointOptions);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CheckpointOptions getCheckpointOptions() {
        return this.checkpointOptions;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TriggerCheckpoint) {
            TriggerCheckpoint that = (TriggerCheckpoint)o;
            return this.timestamp == that.timestamp && super.equals(o);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("Trigger Checkpoint %d@%d for (%s/%s)", new Object[]{this.getCheckpointId(), this.getTimestamp(), this.getJob(), this.getTaskExecutionId()});
    }
}

