/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class AkkaRpcServiceConfiguration {
    @Nonnull
    private final Configuration configuration;
    @Nonnull
    private final Time timeout;
    private final long maximumFramesize;

    public AkkaRpcServiceConfiguration(@Nonnull Configuration configuration, @Nonnull Time timeout, long maximumFramesize) {
        Preconditions.checkArgument((maximumFramesize > 0L ? 1 : 0) != 0, (Object)"Maximum framesize must be positive.");
        this.configuration = configuration;
        this.timeout = timeout;
        this.maximumFramesize = maximumFramesize;
    }

    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Time getTimeout() {
        return this.timeout;
    }

    public long getMaximumFramesize() {
        return this.maximumFramesize;
    }

    public static AkkaRpcServiceConfiguration fromConfiguration(Configuration configuration) {
        FiniteDuration duration = AkkaUtils.getTimeout(configuration);
        Time timeout = Time.of((long)duration.length(), (TimeUnit)duration.unit());
        long maximumFramesize = AkkaRpcServiceUtils.extractMaximumFramesize(configuration);
        return new AkkaRpcServiceConfiguration(configuration, timeout, maximumFramesize);
    }

    public static AkkaRpcServiceConfiguration defaultConfiguration() {
        return AkkaRpcServiceConfiguration.fromConfiguration(new Configuration());
    }
}

