/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class PartitionDescriptor
implements Serializable {
    private static final long serialVersionUID = 6343547936086963705L;
    private final IntermediateDataSetID resultId;
    private final IntermediateResultPartitionID partitionId;
    private final ResultPartitionType partitionType;
    private final int numberOfSubpartitions;
    private final int connectionIndex;

    @VisibleForTesting
    public PartitionDescriptor(IntermediateDataSetID resultId, IntermediateResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int connectionIndex) {
        this.resultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)resultId)));
        this.partitionId = (IntermediateResultPartitionID)((Object)Preconditions.checkNotNull((Object)((Object)partitionId)));
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        Preconditions.checkArgument((numberOfSubpartitions >= 1 ? 1 : 0) != 0);
        this.numberOfSubpartitions = numberOfSubpartitions;
        this.connectionIndex = connectionIndex;
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    public int getNumberOfSubpartitions() {
        return this.numberOfSubpartitions;
    }

    int getConnectionIndex() {
        return this.connectionIndex;
    }

    public String toString() {
        return String.format("PartitionDescriptor [result id: %s, partition id: %s, partition type: %s, subpartitions: %d, connection index: %d]", new Object[]{this.resultId, this.partitionId, this.partitionType, this.numberOfSubpartitions, this.connectionIndex});
    }

    public static PartitionDescriptor from(IntermediateResultPartition partition) {
        Preconditions.checkNotNull((Object)partition);
        int numberOfSubpartitions = 1;
        List<List<ExecutionEdge>> consumers = partition.getConsumers();
        if (!consumers.isEmpty() && !consumers.get(0).isEmpty()) {
            if (consumers.size() > 1) {
                throw new IllegalStateException("Currently, only a single consumer group per partition is supported.");
            }
            numberOfSubpartitions = consumers.get(0).size();
        }
        IntermediateResult result = partition.getIntermediateResult();
        return new PartitionDescriptor(result.getId(), partition.getPartitionId(), result.getResultType(), numberOfSubpartitions, result.getConnectionIndex());
    }
}

