/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorage;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.util.Preconditions;

public class FsCheckpointStorage
extends AbstractFsCheckpointStorage {
    private final FileSystem fileSystem;
    private final Path checkpointsDirectory;
    private final Path sharedStateDirectory;
    private final Path taskOwnedStateDirectory;
    private final int fileSizeThreshold;
    private final int writeBufferSize;

    public FsCheckpointStorage(Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, JobID jobId, int fileSizeThreshold, int writeBufferSize) throws IOException {
        this(checkpointBaseDirectory.getFileSystem(), checkpointBaseDirectory, defaultSavepointDirectory, jobId, fileSizeThreshold, writeBufferSize);
    }

    public FsCheckpointStorage(FileSystem fs, Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, JobID jobId, int fileSizeThreshold, int writeBufferSize) throws IOException {
        super(jobId, defaultSavepointDirectory);
        Preconditions.checkArgument((fileSizeThreshold >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((writeBufferSize >= 0 ? 1 : 0) != 0);
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.checkpointsDirectory = FsCheckpointStorage.getCheckpointDirectoryForJob(checkpointBaseDirectory, jobId);
        this.sharedStateDirectory = new Path(this.checkpointsDirectory, "shared");
        this.taskOwnedStateDirectory = new Path(this.checkpointsDirectory, "taskowned");
        this.fileSizeThreshold = fileSizeThreshold;
        this.writeBufferSize = writeBufferSize;
        this.fileSystem.mkdirs(this.checkpointsDirectory);
        this.fileSystem.mkdirs(this.sharedStateDirectory);
        this.fileSystem.mkdirs(this.taskOwnedStateDirectory);
    }

    public Path getCheckpointsDirectory() {
        return this.checkpointsDirectory;
    }

    @Override
    public boolean supportsHighlyAvailableStorage() {
        return true;
    }

    @Override
    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        Preconditions.checkArgument((checkpointId >= 0L ? 1 : 0) != 0);
        Path checkpointDir = FsCheckpointStorage.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
        this.fileSystem.mkdirs(checkpointDir);
        return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.sharedStateDirectory, this.taskOwnedStateDirectory, CheckpointStorageLocationReference.getDefault(), this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) throws IOException {
        if (reference.isDefaultReference()) {
            Path checkpointDir = FsCheckpointStorage.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
            return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.sharedStateDirectory, this.taskOwnedStateDirectory, reference, this.fileSizeThreshold, this.writeBufferSize);
        }
        Path path = FsCheckpointStorage.decodePathFromReference(reference);
        return new FsCheckpointStorageLocation(path.getFileSystem(), path, path, path, reference, this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStreamFactory.CheckpointStateOutputStream createTaskOwnedStateStream() {
        return new FsCheckpointStreamFactory.FsCheckpointStateOutputStream(this.taskOwnedStateDirectory, this.fileSystem, this.writeBufferSize, this.fileSizeThreshold);
    }

    @Override
    protected CheckpointStorageLocation createSavepointLocation(FileSystem fs, Path location) {
        CheckpointStorageLocationReference reference = FsCheckpointStorage.encodePathAsReference(location);
        return new FsCheckpointStorageLocation(fs, location, location, location, reference, this.fileSizeThreshold, this.writeBufferSize);
    }
}

