/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;

public class ConsumableNotifyingResultPartitionWriterDecorator
implements ResultPartitionWriter {
    private final TaskActions taskActions;
    private final JobID jobId;
    private final ResultPartitionWriter partitionWriter;
    private final ResultPartitionConsumableNotifier partitionConsumableNotifier;
    private boolean hasNotifiedPipelinedConsumers;

    public ConsumableNotifyingResultPartitionWriterDecorator(TaskActions taskActions, JobID jobId, ResultPartitionWriter partitionWriter, ResultPartitionConsumableNotifier partitionConsumableNotifier) {
        this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.partitionWriter = (ResultPartitionWriter)Preconditions.checkNotNull((Object)partitionWriter);
        this.partitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)partitionConsumableNotifier);
    }

    @Override
    public BufferBuilder getBufferBuilder() throws IOException, InterruptedException {
        return this.partitionWriter.getBufferBuilder();
    }

    @Override
    public ResultPartitionID getPartitionId() {
        return this.partitionWriter.getPartitionId();
    }

    @Override
    public int getNumberOfSubpartitions() {
        return this.partitionWriter.getNumberOfSubpartitions();
    }

    @Override
    public int getNumTargetKeyGroups() {
        return this.partitionWriter.getNumTargetKeyGroups();
    }

    @Override
    public void setup() throws IOException {
        this.partitionWriter.setup();
    }

    @Override
    public boolean addBufferConsumer(BufferConsumer bufferConsumer, int subpartitionIndex) throws IOException {
        boolean success = this.partitionWriter.addBufferConsumer(bufferConsumer, subpartitionIndex);
        if (success) {
            this.notifyPipelinedConsumers();
        }
        return success;
    }

    @Override
    public void flushAll() {
        this.partitionWriter.flushAll();
    }

    @Override
    public void flush(int subpartitionIndex) {
        this.partitionWriter.flush(subpartitionIndex);
    }

    @Override
    public void finish() throws IOException {
        this.partitionWriter.finish();
        this.notifyPipelinedConsumers();
    }

    @Override
    public void fail(Throwable throwable) {
        this.partitionWriter.fail(throwable);
    }

    @Override
    public void close() throws Exception {
        this.partitionWriter.close();
    }

    private void notifyPipelinedConsumers() {
        if (!this.hasNotifiedPipelinedConsumers) {
            this.partitionConsumableNotifier.notifyPartitionConsumable(this.jobId, this.partitionWriter.getPartitionId(), this.taskActions);
            this.hasNotifiedPipelinedConsumers = true;
        }
    }

    public static ResultPartitionWriter[] decorate(Collection<ResultPartitionDeploymentDescriptor> descs, ResultPartitionWriter[] partitionWriters, TaskActions taskActions, JobID jobId, ResultPartitionConsumableNotifier notifier) {
        ResultPartitionWriter[] consumableNotifyingPartitionWriters = new ResultPartitionWriter[partitionWriters.length];
        int counter = 0;
        for (ResultPartitionDeploymentDescriptor desc : descs) {
            consumableNotifyingPartitionWriters[counter] = desc.sendScheduleOrUpdateConsumersMessage() && desc.getPartitionType().isPipelined() ? new ConsumableNotifyingResultPartitionWriterDecorator(taskActions, jobId, partitionWriters[counter], notifier) : partitionWriters[counter];
            ++counter;
        }
        return consumableNotifyingPartitionWriters;
    }
}

