/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.Dispatchers;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RARP;
import akka.remote.RARP$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.Transport;
import akka.remote.transport.netty.ClientHandler;
import akka.remote.transport.netty.NettyFutureBridge$;
import akka.remote.transport.netty.NettySSLSupport$;
import akka.remote.transport.netty.NettyTransport$;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.NettyTransportExceptionNoStack;
import akka.remote.transport.netty.NettyTransportSettings;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLSettings;
import akka.remote.transport.netty.ServerHandler;
import akka.remote.transport.netty.TcpClientHandler;
import akka.remote.transport.netty.TcpServerHandler;
import akka.remote.transport.netty.UdpAssociationHandle;
import akka.remote.transport.netty.UdpClientHandler;
import akka.remote.transport.netty.UdpServerHandler;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.shaded.akka.org.jboss.netty.bootstrap.Bootstrap;
import org.apache.flink.shaded.akka.org.jboss.netty.bootstrap.ClientBootstrap;
import org.apache.flink.shaded.akka.org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.apache.flink.shaded.akka.org.jboss.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.akka.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.Channel;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelPipelineFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.DefaultChannelPipeline;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.group.ChannelGroup;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.group.ChannelGroupFuture;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.group.DefaultChannelGroup;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.akka.org.jboss.netty.util.HashedWheelTimer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r]qAB\u0001\u0003\u0011\u0003!!\"\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017\r\u0005\u0002\f\u00195\t!A\u0002\u0004\u000e\u0005!\u0005AA\u0004\u0002\u000f\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u'\taq\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006-1!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0002C\u0004\u001b\u0019\t\u0007I\u0011A\u000e\u0002-\u0019\u0013\u0018-\\3MK:<G\u000f\u001b$jK2$G*\u001a8hi\",\u0012\u0001\b\t\u0003!uI!AH\t\u0003\u0007%sG\u000f\u0003\u0004!\u0019\u0001\u0006I\u0001H\u0001\u0018\rJ\fW.\u001a'f]\u001e$\bNR5fY\u0012dUM\\4uQ\u0002BQA\t\u0007\u0005\u0002\r\nQb\u001a:bG\u00164W\u000f\\\"m_N,GC\u0001\u00131)\t)\u0003\u0006\u0005\u0002\u0011M%\u0011q%\u0005\u0002\u0005+:LG\u000fC\u0003*C\u0001\u000f!&\u0001\u0002fGB\u00111FL\u0007\u0002Y)\u0011Q&E\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0018-\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u00032C\u0001\u0007!'A\u0004dQ\u0006tg.\u001a7\u0011\u0005MRT\"\u0001\u001b\u000b\u0005E*$BA\u00027\u0015\t9\u0004(A\u0003kE>\u001c8OC\u0001:\u0003\ry'oZ\u0005\u0003wQ\u0012qa\u00115b]:,G\u000eC\u0004>\u0019\t\u0007I\u0011\u0001 \u0002\u001fUt\u0017.];f\u0013\u0012\u001cu.\u001e8uKJ,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u0019;p[&\u001c'BA\u0017E\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0006\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bBB&\rA\u0003%q(\u0001\tv]&\fX/Z%e\u0007>,h\u000e^3sA!)Q\n\u0004C\u0001\u001d\u0006A\u0012\r\u001a3sKN\u001chI]8n'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0015\r=C\u0006-\\8s!\r\u0001\u0002KU\u0005\u0003#F\u0011aa\u00149uS>t\u0007CA*W\u001b\u0005!&BA+\t\u0003\u0015\t7\r^8s\u0013\t9FKA\u0004BI\u0012\u0014Xm]:\t\u000bec\u0005\u0019\u0001.\u0002\t\u0005$GM\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\u000b1A\\3u\u0013\tyFLA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\u0006C2\u0003\rAY\u0001\u0011g\u000eDW-\\3JI\u0016tG/\u001b4jKJ\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3\u0012\u001b\u00051'BA4\u0018\u0003\u0019a$o\\8u}%\u0011\u0011.E\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j#!)a\u000e\u0014a\u0001E\u0006Q1/_:uK6t\u0015-\\3\t\u000bAd\u0005\u0019A9\u0002\u0011!|7\u000f\u001e(b[\u0016\u00042\u0001\u0005)c\u0011\u0015\u0019H\n1\u0001u\u0003\u0011\u0001xN\u001d;\u0011\u0007A\u0001F\u0004C\u0003N\u0019\u0011\u0005a\u000fF\u0003PobL(\u0010C\u0003Zk\u0002\u0007!\fC\u0003bk\u0002\u0007!\rC\u0003ok\u0002\u0007!\rC\u0003qk\u0002\u0007\u0011O\u0002\u0003\u000e\u0005\u0001a8cA>\u0010{B\u0011ap`\u0007\u0002\t%\u0019\u0011\u0011\u0001\u0003\u0003\u0013Q\u0013\u0018M\\:q_J$\bBCA\u0003w\n\u0015\r\u0011\"\u0001\u0002\b\u0005A1/\u001a;uS:<7/\u0006\u0002\u0002\nA\u00191\"a\u0003\n\u0007\u00055!A\u0001\fOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;TKR$\u0018N\\4t\u0011)\t\tb\u001fB\u0001B\u0003%\u0011\u0011B\u0001\ng\u0016$H/\u001b8hg\u0002B!\"!\u0006|\u0005\u000b\u0007I\u0011AA\f\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u0011\u0011\u0004\t\u0004'\u0006m\u0011bAA\u000f)\n\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\"Q\u0011\u0011E>\u0003\u0002\u0003\u0006I!!\u0007\u0002\u000fML8\u000f^3nA!1ac\u001fC\u0001\u0003K!b!a\n\u0002*\u0005-\u0002CA\u0006|\u0011!\t)!a\tA\u0002\u0005%\u0001\u0002CA\u000b\u0003G\u0001\r!!\u0007\t\rYYH\u0011AA\u0018)\u0019\t9#!\r\u00024!A\u0011QCA\u0017\u0001\u0004\tI\u0002\u0003\u0005\u00026\u00055\u0002\u0019AA\u001c\u0003\u0011\u0019wN\u001c4\u0011\t\u0005e\u0012qI\u0007\u0003\u0003wQA!!\u0010\u0002@\u000511m\u001c8gS\u001eTA!!\u0011\u0002D\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002F\u0005\u00191m\\7\n\t\u0005%\u00131\b\u0002\u0007\u0007>tg-[4\t\u0013\u000553P1A\u0005\u0004\u0005=\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005Q\u0003bBA*w\u0002\u0006IAK\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003\u0002C1|\u0005\u0004%\t%a\u0016\u0016\u0003\tDq!a\u0017|A\u0003%!-A\ttG\",W.Z%eK:$\u0018NZ5fe\u0002Ba!a\u0018|\t\u0003Z\u0012aE7bq&lW/\u001c)bs2|\u0017\r\u001a\"zi\u0016\u001c\b\"CA2w\n\u0007IQBA3\u0003)I7\u000fR1uC\u001e\u0014\u0018-\\\u000b\u0003\u0003O\u00022\u0001EA5\u0013\r\tY'\u0005\u0002\b\u0005>|G.Z1o\u0011!\tyg\u001fQ\u0001\u000e\u0005\u001d\u0014aC5t\t\u0006$\u0018m\u001a:b[\u0002B1\"a\u001d|\u0001\u0004\u0005\r\u0011\"\u0003\u0002v\u0005aAn\\2bY\u0006#GM]3tgV\t!\u000bC\u0006\u0002zm\u0004\r\u00111A\u0005\n\u0005m\u0014\u0001\u00057pG\u0006d\u0017\t\u001a3sKN\u001cx\fJ3r)\r)\u0013Q\u0010\u0005\n\u0003\u007f\n9(!AA\u0002I\u000b1\u0001\u001f\u00132\u0011\u001d\t\u0019i\u001fQ!\nI\u000bQ\u0002\\8dC2\fE\r\u001a:fgN\u0004\u0003\u0006BAA\u0003\u000f\u00032\u0001EAE\u0013\r\tY)\u0005\u0002\tm>d\u0017\r^5mK\"Y\u0011qR>A\u0002\u0003\u0007I\u0011BA;\u0003\u001d\u0011w.\u001e8e)>D1\"a%|\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\u0006Y!m\\;oIR{w\fJ3r)\r)\u0013q\u0013\u0005\n\u0003\u007f\n\t*!AA\u0002ICq!a'|A\u0003&!+\u0001\u0005c_VtG\rV8!Q\u0011\tI*a\"\t\u0017\u0005\u00056\u00101AA\u0002\u0013%\u00111U\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0003IB1\"a*|\u0001\u0004\u0005\r\u0011\"\u0003\u0002*\u0006\t2/\u001a:wKJ\u001c\u0005.\u00198oK2|F%Z9\u0015\u0007\u0015\nY\u000bC\u0005\u0002\u0000\u0005\u0015\u0016\u0011!a\u0001e!9\u0011qV>!B\u0013\u0011\u0014AD:feZ,'o\u00115b]:,G\u000e\t\u0015\u0005\u0003[\u000b9\tC\u0005\u00026n\u0014\r\u0011\"\u0003\u00028\u0006\u0019An\\4\u0016\u0005\u0005e\u0006\u0003BA^\u0003\u0003l!!!0\u000b\u0007\u0005}\u0006\"A\u0003fm\u0016tG/\u0003\u0003\u0002D\u0006u&\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'\u000f\u0003\u0005\u0002Hn\u0004\u000b\u0011BA]\u0003\u0011awn\u001a\u0011\t\u0015\u0005-7P1A\u0005\u0006\t\ti-\u0001\nvIB\u001cuN\u001c8fGRLwN\u001c+bE2,WCAAh!\u001d\t\t.a5[\u0003/l\u0011aQ\u0005\u0004\u0003+\u001c%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011\u0011\\Av\u001d\u0011\tY.a:\u000f\t\u0005u\u0017Q\u001d\b\u0005\u0003?\f\u0019OD\u0002f\u0003CL\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005%H!A\tBgN|7-[1uS>t\u0007*\u00198eY\u0016LA!!<\u0002p\n\u0019\u0002*\u00198eY\u0016,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0019\u0011\u0011\u001e\u0003\t\u0011\u0005M8\u0010)A\u0007\u0003\u001f\f1#\u001e3q\u0007>tg.Z2uS>tG+\u00192mK\u0002Bq!a>|\t\u0013\tI0A\u000bde\u0016\fG/Z#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0015\u0005\u0005m\b\u0003BAi\u0003{L1!a@D\u0005!)\u00050Z2vi>\u0014\b\"\u0003B\u0002w\n\u0007I\u0011\u0001B\u0003\u00031\u0019\u0007.\u00198oK2<%o\\;q+\t\u00119\u0001\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011i\u0001N\u0001\u0006OJ|W\u000f]\u0005\u0005\u0005#\u0011YAA\nEK\u001a\fW\u000f\u001c;DQ\u0006tg.\u001a7He>,\b\u000f\u0003\u0005\u0003\u0016m\u0004\u000b\u0011\u0002B\u0004\u00035\u0019\u0007.\u00198oK2<%o\\;qA!I!\u0011D>C\u0002\u0013%!1D\u0001\u0015G2LWM\u001c;DQ\u0006tg.\u001a7GC\u000e$xN]=\u0016\u0005\tu\u0001cA\u001a\u0003 %\u0019!\u0011\u0005\u001b\u0003\u001d\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\"A!QE>!\u0002\u0013\u0011i\"A\u000bdY&,g\u000e^\"iC:tW\r\u001c$bGR|'/\u001f\u0011\t\u0013\t%2P1A\u0005\n\tm\u0011\u0001F:feZ,'o\u00115b]:,GNR1di>\u0014\u0018\u0010\u0003\u0005\u0003.m\u0004\u000b\u0011\u0002B\u000f\u0003U\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0002BqA!\r|\t\u0013\u0011\u0019$A\u0006oK^\u0004\u0016\u000e]3mS:,WC\u0001B\u001b!\r\u0019$qG\u0005\u0004\u0005s!$A\u0006#fM\u0006,H\u000e^\"iC:tW\r\u001c)ja\u0016d\u0017N\\3\t\u0013\tu2P1A\u0005\n\t}\u0012AG1tg>\u001c\u0017.\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bK]8nSN,WC\u0001B!!\u0015Y#1\tB$\u0013\r\u0011)\u0005\f\u0002\b!J|W.[:f!\u0011\u0011IEa\u0014\u000f\t\u0005m'1J\u0005\u0004\u0005\u001b\"\u0011!\u0003+sC:\u001c\bo\u001c:u\u0013\u0011\u0011\tFa\u0015\u00031\u0005\u001b8o\\2jCRLwN\\#wK:$H*[:uK:,'OC\u0002\u0003N\u0011A\u0001Ba\u0016|A\u0003%!\u0011I\u0001\u001cCN\u001cxnY5bi&|g\u000eT5ti\u0016tWM\u001d)s_6L7/\u001a\u0011\t\u000f\tm3\u0010\"\u0003\u0003^\u0005Q1o\u001d7IC:$G.\u001a:\u0015\t\t}#q\u000e\t\u0005\u0005C\u0012Y'\u0004\u0002\u0003d)!!Q\rB4\u0003\r\u00198\u000f\u001c\u0006\u0004\u0005S*\u0014a\u00025b]\u0012dWM]\u0005\u0005\u0005[\u0012\u0019G\u0001\u0006Tg2D\u0015M\u001c3mKJD\u0001B!\u001d\u0003Z\u0001\u0007\u0011qM\u0001\tSN\u001cE.[3oi\"I!QO>C\u0002\u0013%!qO\u0001\u0016g\u0016\u0014h/\u001a:QSB,G.\u001b8f\r\u0006\u001cGo\u001c:z+\t\u0011I\bE\u00024\u0005wJ1A! 5\u0005Y\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL\b\u0002\u0003BAw\u0002\u0006IA!\u001f\u0002-M,'O^3s!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\u0002BqA!\"|\t\u0013\u00119)A\u000bdY&,g\u000e\u001e)ja\u0016d\u0017N\\3GC\u000e$xN]=\u0015\t\te$\u0011\u0012\u0005\b\u0005\u0017\u0013\u0019\t1\u0001S\u00035\u0011X-\\8uK\u0006#GM]3tg\"9!qR>\u0005\n\tE\u0015AD:fiV\u0004(i\\8ugR\u0014\u0018\r]\u000b\u0005\u0005'\u0013I\n\u0006\u0004\u0003\u0016\nE&1\u0017\t\u0005\u0005/\u0013I\n\u0004\u0001\u0005\u0011\tm%Q\u0012b\u0001\u0005;\u0013\u0011AQ\t\u0005\u0005?\u0013)\u000bE\u0002\u0011\u0005CK1Aa)\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BAa*\u0003.6\u0011!\u0011\u0016\u0006\u0004\u0005W+\u0014!\u00032p_R\u001cHO]1q\u0013\u0011\u0011yK!+\u0003\u0013\t{w\u000e^:ue\u0006\u0004\b\u0002\u0003BV\u0005\u001b\u0003\rA!&\t\u0011\tU&Q\u0012a\u0001\u0005s\nq\u0002]5qK2Lg.\u001a$bGR|'/\u001f\u0005\n\u0005s[(\u0019!C\u0005\u0005w\u000b\u0001#\u001b8c_VtGMQ8piN$(/\u00199\u0016\u0005\t\u0015\u0006\u0002\u0003B`w\u0002\u0006IA!*\u0002#%t'm\\;oI\n{w\u000e^:ue\u0006\u0004\b\u0005C\u0004\u0003Dn$IA!2\u0002#=,HOY8v]\u0012\u0014un\u001c;tiJ\f\u0007\u000f\u0006\u0003\u0003H\n5\u0007\u0003\u0002BT\u0005\u0013LAAa3\u0003*\ny1\t\\5f]R\u0014un\u001c;tiJ\f\u0007\u000fC\u0004\u0003\f\n\u0005\u0007\u0019\u0001*\t\u000f\tE7\u0010\"\u0011\u0003T\u0006\u0001\u0012n\u001d*fgB|gn]5cY\u00164uN\u001d\u000b\u0005\u0003O\u0012)\u000eC\u0004\u0003X\n=\u0007\u0019\u0001*\u0002\u000f\u0005$GM]3tg\"9!1\\>\u0005\u0002\tu\u0017AF1eIJ,7o\u001d+p'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0015\t\t}'1\u001e\t\u0006W\t\u0005(Q]\u0005\u0004\u0005Gd#A\u0002$viV\u0014X\rE\u0002\\\u0005OL1A!;]\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\u00073\ne\u0007\u0019\u0001*\t\u000f\t=8\u0010\"\u0011\u0003r\u00061A.[:uK:,\"Aa=\u0011\u000b-\u0012\tO!>\u0011\rA\u00119P\u0015B!\u0013\r\u0011I0\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\tu8\u0010\"\u0001\t\u0003k\nABY8v]\u0012\fE\r\u001a:fgNDqa!\u0001|\t\u0003\u001a\u0019!A\u0005bgN|7-[1uKR!1QAB\u0007!\u0015Y#\u0011]B\u0004!\rq8\u0011B\u0005\u0004\u0007\u0017!!!E!tg>\u001c\u0017.\u0019;j_:D\u0015M\u001c3mK\"9!1\u0012B\u0000\u0001\u0004\u0011\u0006bBB\tw\u0012\u000531C\u0001\tg\",H\u000fZ8x]R\u00111Q\u0003\t\u0006W\t\u0005\u0018q\r")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private final boolean akka$remote$transport$netty$NettyTransport$$isDatagram;
    private volatile Address localAddress;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    public final boolean akka$remote$transport$netty$NettyTransport$$isDatagram() {
        return this.akka$remote$transport$netty$NettyTransport$$isDatagram;
    }

    private Address localAddress() {
        return this.localAddress;
    }

    private void localAddress_$eq(Address x$1) {
        this.localAddress = x$1;
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log() {
        return this.akka$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelPipeline akka$remote$transport$netty$NettyTransport$$newPipeline() {
        void var1_1;
        block0: {
            DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
            if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) break block0;
            pipeline.addLast("FrameDecoder", new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
            pipeline.addLast("FrameEncoder", new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        }
        return var1_1;
    }

    public Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler akka$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        void var2_2;
        SslHandler handler = NettySSLSupport$.MODULE$.apply((SSLSettings)this.settings().SslSettings().get(), this.akka$remote$transport$netty$NettyTransport$$log(), isClient);
        handler.setCloseOnSSLException(true);
        return var2_2;
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                ClientHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpClientHandler(this.$outer, this.remoteAddress$1) : new TcpClientHandler(this.$outer, this.remoteAddress$1, (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) {
            bootstrap.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(BoxesRunTime.unboxToInt((Object)this.settings().ReceiveBufferSize().get())));
        }
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    /*
     * WARNING - void declaration
     */
    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        void var2_2;
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger((int)sz)));
        return var2_2;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address == null) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] does not contain host or port information."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addr}))));
        Option option = address.host();
        Option option2 = address.port();
        if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] does not contain host or port information."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addr}))));
        Some some = (Some)option;
        String host = (String)some.value();
        if (!(option2 instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] does not contain host or port information."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addr}))));
        Some some2 = (Some)option2;
        int port = BoxesRunTime.unboxToInt((Object)some2.value());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), this.settings().BindPortSelector())).map((Function1 & Serializable & scala.Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new MatchError((Object)bootstrap);
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)(this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()))));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown local address type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newServerChannel.getLocalAddress().getClass().getName()})));
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown local address type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newServerChannel.getLocalAddress().getClass().getName()})));
                    }
                    throw new MatchError(option);
                }
                this.localAddress_$eq(address2);
                this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future().onSuccess((PartialFunction)new scala.Serializable(null, newServerChannel){
                    public static final long serialVersionUID = 0L;
                    private final Channel newServerChannel$1;

                    public final <A1 extends Transport.AssociationEventListener, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        A1 A1 = x5;
                        ChannelFuture channelFuture = this.newServerChannel$1.setReadable(true);
                        return (B1)channelFuture;
                    }

                    public final boolean isDefinedAt(Transport.AssociationEventListener x5) {
                        Transport.AssociationEventListener associationEventListener = x5;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.newServerChannel$1 = newServerChannel$1;
                    }
                }, this.executionContext());
                Tuple2 tuple22 = new Tuple2((Object)address2, this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise());
                tuple2 = tuple22;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    this.akka$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                    try {
                        boxedUnit = this.shutdown();
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        Option option3 = NonFatal$.MODULE$.unapply(throwable4);
                        if (option3.isEmpty()) {
                            throw throwable3;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        boxedUnit = boxedUnit2;
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        Future future;
        if (!this.serverChannel().isBound()) {
            future = Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        } else {
            ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
            future = this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable & scala.Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable & scala.Serializable)channel -> {
                Object object = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> channel.getPipeline().get(SslHandler.class).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
                Object object2 = !this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? channel.setReadable(false) : BoxedUnit.UNIT;
                return channel;
            }, this.executionContext()).flatMap((Function1 & Serializable & scala.Serializable)readyChannel -> (this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                SocketAddress socketAddress = readyChannel.getRemoteAddress();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    throw new NettyTransportException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown outbound remote address type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress.getClass().getName()})));
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                UdpAssociationHandle handle = new UdpAssociationHandle(this.localAddress(), remoteAddress, (Channel)readyChannel, this);
                handle.readHandlerPromise().future().onSuccess((PartialFunction)new scala.Serializable(this, inetSocketAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyTransport $outer;
                    private final InetSocketAddress x2$3;

                    public final <A1 extends AssociationHandle.HandleEventListener, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        A1 A1 = x6;
                        AssociationHandle.HandleEventListener handleEventListener = this.$outer.udpConnectionTable().put(this.x2$3, A1);
                        return (B1)handleEventListener;
                    }

                    public final boolean isDefinedAt(AssociationHandle.HandleEventListener x6) {
                        AssociationHandle.HandleEventListener handleEventListener = x6;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x2$3 = x2$3;
                    }
                }, this.executionContext());
                UdpAssociationHandle udpAssociationHandle = handle;
                return udpAssociationHandle;
            }, this.executionContext()) : readyChannel.getPipeline().get(ClientHandler.class).statusFuture()).map((Function1 & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    A1 A1 = x7;
                    if (A1 instanceof CancellationException) {
                        throw new NettyTransportExceptionNoStack("Connection was cancelled");
                    }
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", caused by: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage(), t.getCause()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", caused by: ", ", caused by: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage(), t.getCause(), t.getCause().getCause()})));
                        throw new NettyTransportExceptionNoStack(msg, t.getCause());
                    }
                    Object object = function1.apply(x7);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x7) {
                    Option option;
                    Throwable throwable = x7;
                    boolean bl = throwable instanceof CancellationException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
            }, this.executionContext());
        }
        return future;
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1 & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$4) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$4)), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                A1 A1 = x8;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x8) {
                Throwable throwable = x8;
                boolean bl = true;
                return bl;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, unbindStatus$1, lastWriteStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, unbindStatus$1, lastWriteStatus, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write(ChannelBuffers.buffer(0))).flatMap((Function1 & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        Bootstrap bootstrap;
        ChannelFactory channelFactory;
        ChannelFactory channelFactory2;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
            return object;
        }).map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = (settings.EnableSsl() ? "ssl." : "") + settings.TransportMode();
        NettyTransportSettings.Mode mode = settings.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        this.akka$remote$transport$netty$NettyTransport$$isDatagram = !(mode != null ? !mode.equals(nettyTransportSettings$Udp$) : nettyTransportSettings$Udp$ != null);
        this.akka$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup("akka-netty-transport-driver-channelgroup-" + NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement());
        NettyTransportSettings.Mode mode2 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode2)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            channelFactory2 = new NioClientSocketChannelFactory(boss, 1, new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), new HashedWheelTimer(system.threadFactory()));
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode2)) {
            channelFactory2 = new NioDatagramChannelFactory(this.createExecutorService(), settings.ClientSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode2);
        }
        this.clientChannelFactory = channelFactory2;
        NettyTransportSettings.Mode mode3 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode3)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            channelFactory = new NioServerSocketChannelFactory(boss, worker, settings.ServerSocketWorkerPoolSize());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode3)) {
            channelFactory = new NioDatagramChannelFactory(this.createExecutorService(), settings.ServerSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode3);
        }
        this.serverChannelFactory = channelFactory;
        this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                ServerHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future()) : new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        NettyTransportSettings.Mode mode4 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode4)) {
            bootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode4)) {
            bootstrap = this.setupBootstrap(new ConnectionlessBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else {
            throw new MatchError((Object)mode4);
        }
        this.inboundBootstrap = bootstrap;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

