/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class SlotProfile {
    private static final SlotProfile NO_REQUIREMENTS = SlotProfile.noLocality(ResourceProfile.UNKNOWN);
    @Nonnull
    private final ResourceProfile resourceProfile;
    @Nonnull
    private final Collection<TaskManagerLocation> preferredLocations;
    @Nonnull
    private final Collection<AllocationID> preferredAllocations;
    @Nonnull
    private final Set<AllocationID> previousExecutionGraphAllocations;

    public SlotProfile(@Nonnull ResourceProfile resourceProfile, @Nonnull Collection<TaskManagerLocation> preferredLocations, @Nonnull Collection<AllocationID> preferredAllocations) {
        this(resourceProfile, preferredLocations, preferredAllocations, Collections.emptySet());
    }

    public SlotProfile(@Nonnull ResourceProfile resourceProfile, @Nonnull Collection<TaskManagerLocation> preferredLocations, @Nonnull Collection<AllocationID> preferredAllocations, @Nonnull Set<AllocationID> previousExecutionGraphAllocations) {
        this.resourceProfile = resourceProfile;
        this.preferredLocations = preferredLocations;
        this.preferredAllocations = preferredAllocations;
        this.previousExecutionGraphAllocations = previousExecutionGraphAllocations;
    }

    @Nonnull
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Nonnull
    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    @Nonnull
    public Collection<AllocationID> getPreferredAllocations() {
        return this.preferredAllocations;
    }

    @Nonnull
    public Set<AllocationID> getPreviousExecutionGraphAllocations() {
        return this.previousExecutionGraphAllocations;
    }

    public static SlotProfile noRequirements() {
        return NO_REQUIREMENTS;
    }

    public static SlotProfile noLocality(ResourceProfile resourceProfile) {
        return new SlotProfile(resourceProfile, Collections.emptyList(), Collections.emptyList());
    }

    public static SlotProfile preferredLocality(ResourceProfile resourceProfile, Collection<TaskManagerLocation> preferredLocations) {
        return new SlotProfile(resourceProfile, preferredLocations, Collections.emptyList());
    }

    public static SlotProfile priorAllocation(ResourceProfile resourceProfile, Collection<AllocationID> priorAllocations) {
        return new SlotProfile(resourceProfile, Collections.emptyList(), priorAllocations);
    }
}

