/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;

public class DispatcherResourceManagerComponent<T extends Dispatcher>
implements AutoCloseableAsync {
    @Nonnull
    private final T dispatcher;
    @Nonnull
    private final ResourceManager<?> resourceManager;
    @Nonnull
    private final LeaderRetrievalService dispatcherLeaderRetrievalService;
    @Nonnull
    private final LeaderRetrievalService resourceManagerRetrievalService;
    @Nonnull
    private final WebMonitorEndpoint<?> webMonitorEndpoint;
    @Nonnull
    private final JobManagerMetricGroup jobManagerMetricGroup;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    DispatcherResourceManagerComponent(@Nonnull T dispatcher, @Nonnull ResourceManager<?> resourceManager, @Nonnull LeaderRetrievalService dispatcherLeaderRetrievalService, @Nonnull LeaderRetrievalService resourceManagerRetrievalService, @Nonnull WebMonitorEndpoint<?> webMonitorEndpoint, @Nonnull JobManagerMetricGroup jobManagerMetricGroup) {
        this.resourceManager = resourceManager;
        this.dispatcher = dispatcher;
        this.dispatcherLeaderRetrievalService = dispatcherLeaderRetrievalService;
        this.resourceManagerRetrievalService = resourceManagerRetrievalService;
        this.webMonitorEndpoint = webMonitorEndpoint;
        this.jobManagerMetricGroup = jobManagerMetricGroup;
        this.terminationFuture = new CompletableFuture();
        this.shutDownFuture = new CompletableFuture();
        this.registerShutDownFuture();
    }

    private void registerShutDownFuture() {
        this.terminationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.shutDownFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.shutDownFuture.complete(ApplicationStatus.SUCCEEDED);
            }
        });
        ((RpcEndpoint)this.dispatcher).getTerminationFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.shutDownFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.shutDownFuture.complete(ApplicationStatus.SUCCEEDED);
            }
        });
    }

    public final CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    @Nonnull
    public T getDispatcher() {
        return this.dispatcher;
    }

    @Nonnull
    public WebMonitorEndpoint<?> getWebMonitorEndpoint() {
        return this.webMonitorEndpoint;
    }

    public CompletableFuture<Void> deregisterApplicationAndClose(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        if (this.isRunning.compareAndSet(true, false)) {
            CompletableFuture<Void> closeWebMonitorAndDeregisterAppFuture = FutureUtils.composeAfterwards(this.webMonitorEndpoint.closeAsync(), () -> this.deregisterApplication(applicationStatus, diagnostics));
            return FutureUtils.composeAfterwards(closeWebMonitorAndDeregisterAppFuture, this::closeAsyncInternal);
        }
        return this.terminationFuture;
    }

    private CompletableFuture<Void> deregisterApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        ResourceManagerGateway selfGateway = this.resourceManager.getSelfGateway(ResourceManagerGateway.class);
        return selfGateway.deregisterApplication(applicationStatus, diagnostics).thenApply(ack -> null);
    }

    private CompletableFuture<Void> closeAsyncInternal() {
        Exception exception = null;
        ArrayList terminationFutures = new ArrayList(3);
        try {
            this.dispatcherLeaderRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
        }
        try {
            this.resourceManagerRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        terminationFutures.add(((RpcEndpoint)this.dispatcher).closeAsync());
        terminationFutures.add(this.resourceManager.closeAsync());
        if (exception != null) {
            terminationFutures.add(FutureUtils.completedExceptionally(exception));
        }
        FutureUtils.ConjunctFuture<Void> componentTerminationFuture = FutureUtils.completeAll(terminationFutures);
        CompletableFuture<Void> metricGroupTerminationFuture = FutureUtils.runAfterwards(componentTerminationFuture, this.jobManagerMetricGroup::close);
        metricGroupTerminationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.terminationFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.terminationFuture.complete((Void)aVoid);
            }
        });
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.deregisterApplicationAndClose(ApplicationStatus.CANCELED, "DispatcherResourceManagerComponent has been closed.");
    }
}

