/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;

public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = -6138942031953594202L;
    private final SerializedThrowable exception;
    private final long timestamp;

    public ErrorInfo(Throwable exception, long timestamp) {
        Preconditions.checkNotNull((Object)exception);
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0);
        this.exception = exception instanceof SerializedThrowable ? (SerializedThrowable)exception : new SerializedThrowable(exception);
        this.timestamp = timestamp;
    }

    public SerializedThrowable getException() {
        return this.exception;
    }

    public String getExceptionAsString() {
        return this.exception.getFullStringifiedStackTrace();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

