/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import akka.actor.ActorRef;
import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionStatusListener;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;

public class StatusListenerMessenger
implements JobStatusListener,
ExecutionStatusListener {
    private final AkkaActorGateway target;

    public StatusListenerMessenger(ActorRef target, UUID leaderSessionId) {
        this.target = new AkkaActorGateway((ActorRef)Preconditions.checkNotNull((Object)target), leaderSessionId);
    }

    @Override
    public void jobStatusChanges(JobID jobId, JobStatus newJobStatus, long timestamp, Throwable error) {
        ExecutionGraphMessages.JobStatusChanged message = new ExecutionGraphMessages.JobStatusChanged(jobId, newJobStatus, timestamp, (Throwable)(error == null ? null : new SerializedThrowable(error)));
        this.target.tell(message);
    }

    @Override
    public void executionStatusChanged(JobID jobID, JobVertexID vertexID, String taskName, int taskParallelism, int subtaskIndex, ExecutionAttemptID executionID, ExecutionState newExecutionState, long timestamp, String optionalMessage) {
        ExecutionGraphMessages.ExecutionStateChanged message = new ExecutionGraphMessages.ExecutionStateChanged(jobID, vertexID, taskName, taskParallelism, subtaskIndex, executionID, newExecutionState, timestamp, optionalMessage);
        this.target.tell(message);
    }
}

