/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.slf4j.Logger;

public class HeartbeatManagerSenderImpl<I, O>
extends HeartbeatManagerImpl<I, O>
implements Runnable {
    private final long heartbeatPeriod;

    HeartbeatManagerSenderImpl(long heartbeatPeriod, long heartbeatTimeout, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        super(heartbeatTimeout, ownResourceID, heartbeatListener, mainThreadExecutor, log);
        this.heartbeatPeriod = heartbeatPeriod;
        mainThreadExecutor.schedule(this, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (!this.stopped) {
            this.log.debug("Trigger heartbeat request.");
            for (HeartbeatManagerImpl.HeartbeatMonitor heartbeatMonitor : this.getHeartbeatTargets()) {
                this.requestHeartbeat(heartbeatMonitor);
            }
            this.getMainThreadExecutor().schedule(this, this.heartbeatPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void requestHeartbeat(HeartbeatManagerImpl.HeartbeatMonitor<O> heartbeatMonitor) {
        Object payload = this.getHeartbeatListener().retrievePayload(heartbeatMonitor.getHeartbeatTargetId());
        HeartbeatTarget<O> heartbeatTarget = heartbeatMonitor.getHeartbeatTarget();
        heartbeatTarget.requestHeartbeat(this.getOwnResourceID(), payload);
    }
}

