/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SavepointRestoreSettings
implements Serializable {
    private static final long serialVersionUID = 87377506900849777L;
    private static final SavepointRestoreSettings NONE = new SavepointRestoreSettings(null, false);
    private static final boolean DEFAULT_ALLOW_NON_RESTORED_STATE = false;
    private final String restorePath;
    private final boolean allowNonRestoredState;

    private SavepointRestoreSettings(String restorePath, boolean allowNonRestoredState) {
        this.restorePath = restorePath;
        this.allowNonRestoredState = allowNonRestoredState;
    }

    public boolean restoreSavepoint() {
        return this.restorePath != null;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public boolean allowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavepointRestoreSettings that = (SavepointRestoreSettings)o;
        return this.allowNonRestoredState == that.allowNonRestoredState && (this.restorePath != null ? this.restorePath.equals(that.restorePath) : that.restorePath == null);
    }

    public int hashCode() {
        int result = this.restorePath != null ? this.restorePath.hashCode() : 0;
        result = 31 * result + (this.allowNonRestoredState ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.restoreSavepoint()) {
            return "SavepointRestoreSettings.forPath(restorePath='" + this.restorePath + '\'' + ", allowNonRestoredState=" + this.allowNonRestoredState + ')';
        }
        return "SavepointRestoreSettings.none()";
    }

    public static SavepointRestoreSettings none() {
        return NONE;
    }

    public static SavepointRestoreSettings forPath(String savepointPath) {
        return SavepointRestoreSettings.forPath(savepointPath, false);
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState) {
        Preconditions.checkNotNull((Object)savepointPath, (String)"Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState);
    }
}

