/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

public enum PreviousAllocationSlotSelectionStrategy implements SlotSelectionStrategy
{
    INSTANCE;


    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<? extends SlotInfo> availableSlots, @Nonnull SlotProfile slotProfile) {
        Collection<AllocationID> priorAllocations = slotProfile.getPreferredAllocations();
        if (!priorAllocations.isEmpty()) {
            for (SlotInfo slotInfo : availableSlots) {
                if (!priorAllocations.contains((Object)slotInfo.getAllocationId())) continue;
                return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(slotInfo, Locality.LOCAL));
            }
        }
        Set<AllocationID> blackListedAllocations = slotProfile.getPreviousExecutionGraphAllocations();
        Collection<SlotInfo> collection = this.computeWithoutBlacklistedSlots(availableSlots, blackListedAllocations);
        return LocationPreferenceSlotSelectionStrategy.INSTANCE.selectBestSlotForProfile(collection, slotProfile);
    }

    @Nonnull
    private Collection<SlotInfo> computeWithoutBlacklistedSlots(@Nonnull Collection<? extends SlotInfo> availableSlots, @Nonnull Set<AllocationID> blacklistedAllocations) {
        if (blacklistedAllocations.isEmpty()) {
            return Collections.unmodifiableCollection(availableSlots);
        }
        ArrayList<SlotInfo> availableAndAllowedSlots = new ArrayList<SlotInfo>(availableSlots.size());
        for (SlotInfo slotInfo : availableSlots) {
            if (blacklistedAllocations.contains((Object)slotInfo.getAllocationId())) continue;
            availableAndAllowedSlots.add(slotInfo);
        }
        return availableAndAllowedSlots;
    }
}

