/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Objects;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskexecutor.StackTraceSampleableTask;
import org.apache.flink.runtime.taskmanager.Task;

class TaskStackTraceSampleableTaskAdapter
implements StackTraceSampleableTask {
    private final Task task;

    static TaskStackTraceSampleableTaskAdapter fromTask(Task task) {
        return new TaskStackTraceSampleableTaskAdapter(task);
    }

    private TaskStackTraceSampleableTaskAdapter(Task task) {
        this.task = Objects.requireNonNull(task, "task must not be null");
    }

    @Override
    public boolean isRunning() {
        return this.task.getExecutionState() == ExecutionState.RUNNING;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.task.getExecutingThread().getStackTrace();
    }

    @Override
    public ExecutionAttemptID getExecutionId() {
        return this.task.getExecutionId();
    }
}

