/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.AkkaQueryServiceGateway;
import org.apache.flink.util.Preconditions;

public class AkkaQueryServiceRetriever
implements MetricQueryServiceRetriever {
    private final ActorSystem actorSystem;
    private final Time lookupTimeout;

    public AkkaQueryServiceRetriever(ActorSystem actorSystem, Time lookupTimeout) {
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem);
        this.lookupTimeout = (Time)Preconditions.checkNotNull((Object)lookupTimeout);
    }

    @Override
    public CompletableFuture<MetricQueryServiceGateway> retrieveService(String queryServicePath) {
        ActorSelection selection = this.actorSystem.actorSelection(queryServicePath);
        return FutureUtils.toJava(selection.resolveOne(FutureUtils.toFiniteDuration(this.lookupTimeout))).thenApply(AkkaQueryServiceGateway::new);
    }
}

