/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.conf.Reconfigurable;
import org.apache.hadoop.conf.ReconfigurationException;

public abstract class ReconfigurableBase
extends Configured
implements Reconfigurable {
    private static final Log LOG = LogFactory.getLog(ReconfigurableBase.class);

    public ReconfigurableBase() {
        super(new Configuration());
    }

    public ReconfigurableBase(Configuration conf) {
        super(conf == null ? new Configuration() : conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String reconfigureProperty(String property, String newVal) throws ReconfigurationException {
        if (this.isPropertyReconfigurable(property)) {
            String oldVal;
            LOG.info("changing property " + property + " to " + newVal);
            Configuration configuration = this.getConf();
            synchronized (configuration) {
                oldVal = this.getConf().get(property);
                this.reconfigurePropertyImpl(property, newVal);
                if (newVal != null) {
                    this.getConf().set(property, newVal);
                } else {
                    this.getConf().unset(property);
                }
            }
            return oldVal;
        }
        throw new ReconfigurationException(property, newVal, this.getConf().get(property));
    }

    @Override
    public abstract Collection<String> getReconfigurableProperties();

    @Override
    public boolean isPropertyReconfigurable(String property) {
        return this.getReconfigurableProperties().contains(property);
    }

    protected abstract void reconfigurePropertyImpl(String var1, String var2) throws ReconfigurationException;
}

