/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public abstract class HAAdmin
extends Configured
implements Tool {
    private static final String FORCEFENCE = "forcefence";
    private static final String FORCEACTIVE = "forceactive";
    private static final String FORCEMANUAL = "forcemanual";
    private static final Log LOG = LogFactory.getLog(HAAdmin.class);
    private int rpcTimeoutForChecks = -1;
    protected static final Map<String, UsageInfo> USAGE = ImmutableMap.builder().put("-transitionToActive", new UsageInfo("<serviceId>", "Transitions the service into Active state")).put("-transitionToStandby", new UsageInfo("<serviceId>", "Transitions the service into Standby state")).put("-failover", new UsageInfo("[--forcefence] [--forceactive] <serviceId> <serviceId>", "Failover from the first service to the second.\nUnconditionally fence services if the forcefence option is used.\nTry to failover to the target service even if it is not ready if the forceactive option is used.")).put("-getServiceState", new UsageInfo("<serviceId>", "Returns the state of the service")).put("-checkHealth", new UsageInfo("<serviceId>", "Requests that the service perform a health check.\nThe HAAdmin tool will exit with a non-zero exit code\nif the check fails.")).put("-help", new UsageInfo("<command>", "Displays help on the specified command")).build();
    protected PrintStream errOut = System.err;
    protected PrintStream out = System.out;
    private HAServiceProtocol.RequestSource requestSource = HAServiceProtocol.RequestSource.REQUEST_BY_USER;

    protected HAAdmin() {
    }

    protected HAAdmin(Configuration conf) {
        super(conf);
    }

    protected abstract HAServiceTarget resolveTarget(String var1);

    protected String getUsageString() {
        return "Usage: HAAdmin";
    }

    protected void printUsage(PrintStream errOut) {
        errOut.println(this.getUsageString());
        for (Map.Entry<String, UsageInfo> e : USAGE.entrySet()) {
            String cmd = e.getKey();
            UsageInfo usage = e.getValue();
            errOut.println("    [" + cmd + " " + usage.args + "]");
        }
        errOut.println();
        ToolRunner.printGenericCommandUsage(errOut);
    }

    private static void printUsage(PrintStream errOut, String cmd) {
        UsageInfo usage = USAGE.get(cmd);
        if (usage == null) {
            throw new RuntimeException("No usage for cmd " + cmd);
        }
        errOut.println("Usage: HAAdmin [" + cmd + " " + usage.args + "]");
    }

    private int transitionToActive(CommandLine cmd) throws IOException, ServiceFailedException {
        String[] argv = cmd.getArgs();
        if (argv.length != 1) {
            this.errOut.println("transitionToActive: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-transitionToActive");
            return -1;
        }
        HAServiceTarget target = this.resolveTarget(argv[0]);
        if (!this.checkManualStateManagementOK(target)) {
            return -1;
        }
        HAServiceProtocol proto = target.getProxy(this.getConf(), 0);
        HAServiceProtocolHelper.transitionToActive(proto, this.createReqInfo());
        return 0;
    }

    private int transitionToStandby(CommandLine cmd) throws IOException, ServiceFailedException {
        String[] argv = cmd.getArgs();
        if (argv.length != 1) {
            this.errOut.println("transitionToStandby: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-transitionToStandby");
            return -1;
        }
        HAServiceTarget target = this.resolveTarget(argv[0]);
        if (!this.checkManualStateManagementOK(target)) {
            return -1;
        }
        HAServiceProtocol proto = target.getProxy(this.getConf(), 0);
        HAServiceProtocolHelper.transitionToStandby(proto, this.createReqInfo());
        return 0;
    }

    private boolean checkManualStateManagementOK(HAServiceTarget target) {
        if (target.isAutoFailoverEnabled()) {
            if (this.requestSource != HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED) {
                this.errOut.println("Automatic failover is enabled for " + target + "\n" + "Refusing to manually manage HA state, since it may cause\n" + "a split-brain scenario or other incorrect state.\n" + "If you are very sure you know what you are doing, please \n" + "specify the " + FORCEMANUAL + " flag.");
                return false;
            }
            LOG.warn("Proceeding with manual HA state management even though\nautomatic failover is enabled for " + target);
            return true;
        }
        return true;
    }

    private HAServiceProtocol.StateChangeRequestInfo createReqInfo() {
        return new HAServiceProtocol.StateChangeRequestInfo(this.requestSource);
    }

    private int failover(CommandLine cmd) throws IOException, ServiceFailedException {
        boolean forceFence = cmd.hasOption(FORCEFENCE);
        boolean forceActive = cmd.hasOption(FORCEACTIVE);
        int numOpts = cmd.getOptions() == null ? 0 : cmd.getOptions().length;
        String[] args = cmd.getArgs();
        if (numOpts > 3 || args.length != 2) {
            this.errOut.println("failover: incorrect arguments");
            HAAdmin.printUsage(this.errOut, "-failover");
            return -1;
        }
        HAServiceTarget fromNode = this.resolveTarget(args[0]);
        HAServiceTarget toNode = this.resolveTarget(args[1]);
        Preconditions.checkState(fromNode.isAutoFailoverEnabled() == toNode.isAutoFailoverEnabled(), "Inconsistent auto-failover configs between %s and %s!", fromNode, toNode);
        if (fromNode.isAutoFailoverEnabled()) {
            if (forceFence || forceActive) {
                this.errOut.println("forcefence and forceactive flags not supported with auto-failover enabled.");
                return -1;
            }
            return this.gracefulFailoverThroughZKFCs(toNode);
        }
        FailoverController fc = new FailoverController(this.getConf(), this.requestSource);
        try {
            fc.failover(fromNode, toNode, forceFence, forceActive);
            this.out.println("Failover from " + args[0] + " to " + args[1] + " successful");
        }
        catch (FailoverFailedException ffe) {
            this.errOut.println("Failover failed: " + ffe.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    private int gracefulFailoverThroughZKFCs(HAServiceTarget toNode) throws IOException {
        int timeout = FailoverController.getRpcTimeoutToNewActive(this.getConf());
        ZKFCProtocol proxy = toNode.getZKFCProxy(this.getConf(), timeout);
        try {
            proxy.gracefulFailover();
            this.out.println("Failover to " + toNode + " successful");
        }
        catch (ServiceFailedException sfe) {
            this.errOut.println("Failover failed: " + sfe.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    private int checkHealth(CommandLine cmd) throws IOException, ServiceFailedException {
        String[] argv = cmd.getArgs();
        if (argv.length != 1) {
            this.errOut.println("checkHealth: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-checkHealth");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[0]).getProxy(this.getConf(), this.rpcTimeoutForChecks);
        try {
            HAServiceProtocolHelper.monitorHealth(proto, this.createReqInfo());
        }
        catch (HealthCheckFailedException e) {
            this.errOut.println("Health check failed: " + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    private int getServiceState(CommandLine cmd) throws IOException, ServiceFailedException {
        String[] argv = cmd.getArgs();
        if (argv.length != 1) {
            this.errOut.println("getServiceState: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-getServiceState");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[0]).getProxy(this.getConf(), this.rpcTimeoutForChecks);
        this.out.println((Object)proto.getServiceStatus().getState());
        return 0;
    }

    protected String getServiceAddr(String serviceId) {
        return serviceId;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.rpcTimeoutForChecks = conf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        try {
            return this.runCmd(argv);
        }
        catch (IllegalArgumentException iae) {
            this.errOut.println("Illegal argument: " + iae.getLocalizedMessage());
            return -1;
        }
        catch (IOException ioe) {
            this.errOut.println("Operation failed: " + ioe.getLocalizedMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Operation failed", ioe);
            }
            return -1;
        }
    }

    protected int runCmd(String[] argv) throws Exception {
        CommandLine cmdLine;
        if (argv.length < 1) {
            this.printUsage(this.errOut);
            return -1;
        }
        String cmd = argv[0];
        if (!cmd.startsWith("-")) {
            this.errOut.println("Bad command '" + cmd + "': expected command starting with '-'");
            this.printUsage(this.errOut);
            return -1;
        }
        if (!USAGE.containsKey(cmd)) {
            this.errOut.println(cmd.substring(1) + ": Unknown command");
            this.printUsage(this.errOut);
            return -1;
        }
        Options opts = new Options();
        if ("-failover".equals(cmd)) {
            this.addFailoverCliOpts(opts);
        }
        if ("-transitionToActive".equals(cmd) || "-transitionToStandby".equals(cmd) || "-failover".equals(cmd)) {
            opts.addOption(FORCEMANUAL, false, "force manual control even if auto-failover is enabled");
        }
        if ((cmdLine = this.parseOpts(cmd, opts, argv)) == null) {
            return -1;
        }
        if (cmdLine.hasOption(FORCEMANUAL)) {
            if (!this.confirmForceManual()) {
                LOG.fatal("Aborted");
                return -1;
            }
            this.requestSource = HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED;
        }
        if ("-transitionToActive".equals(cmd)) {
            return this.transitionToActive(cmdLine);
        }
        if ("-transitionToStandby".equals(cmd)) {
            return this.transitionToStandby(cmdLine);
        }
        if ("-failover".equals(cmd)) {
            return this.failover(cmdLine);
        }
        if ("-getServiceState".equals(cmd)) {
            return this.getServiceState(cmdLine);
        }
        if ("-checkHealth".equals(cmd)) {
            return this.checkHealth(cmdLine);
        }
        if ("-help".equals(cmd)) {
            return this.help(argv);
        }
        throw new AssertionError((Object)("Should not get here, command: " + cmd));
    }

    private boolean confirmForceManual() throws IOException {
        return ToolRunner.confirmPrompt("You have specified the forcemanual flag. This flag is dangerous, as it can induce a split-brain scenario that WILL CORRUPT your HDFS namespace, possibly irrecoverably.\n\nIt is recommended not to use this flag, but instead to shut down the cluster and disable automatic failover if you prefer to manually manage your HA state.\n\nYou may abort safely by answering 'n' or hitting ^C now.\n\nAre you sure you want to continue?");
    }

    private void addFailoverCliOpts(Options failoverOpts) {
        failoverOpts.addOption(FORCEFENCE, false, "force fencing");
        failoverOpts.addOption(FORCEACTIVE, false, "force failover");
    }

    private CommandLine parseOpts(String cmdName, Options opts, String[] argv) {
        try {
            argv = Arrays.copyOfRange(argv, 1, argv.length);
            return new GnuParser().parse(opts, argv);
        }
        catch (ParseException pe) {
            this.errOut.println(cmdName.substring(1) + ": incorrect arguments");
            HAAdmin.printUsage(this.errOut, cmdName);
            return null;
        }
    }

    private int help(String[] argv) {
        UsageInfo usageInfo;
        if (argv.length == 1) {
            this.printUsage(this.out);
            return 0;
        }
        if (argv.length != 2) {
            HAAdmin.printUsage(this.errOut, "-help");
            return -1;
        }
        String cmd = argv[1];
        if (!cmd.startsWith("-")) {
            cmd = "-" + cmd;
        }
        if ((usageInfo = USAGE.get(cmd)) == null) {
            this.errOut.println(cmd + ": Unknown command");
            this.printUsage(this.errOut);
            return -1;
        }
        this.out.println(cmd + " [" + usageInfo.args + "]: " + usageInfo.help);
        return 0;
    }

    protected static class UsageInfo {
        public final String args;
        public final String help;

        public UsageInfo(String args, String help) {
            this.args = args;
            this.help = help;
        }
    }
}

