/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.hadoop2.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PipelineAck {
    DataTransferProtos.PipelineAckProto proto;
    public static final long UNKOWN_SEQNO = -2L;
    static final int OOB_START = 8;
    static final int OOB_END = 11;
    static final int NUM_OOB_TYPES = 4;
    static final long[] OOB_TIMEOUT = new long[4];

    public PipelineAck() {
    }

    public PipelineAck(long seqno, DataTransferProtos.Status[] replies) {
        this(seqno, replies, 0L);
    }

    public PipelineAck(long seqno, DataTransferProtos.Status[] replies, long downstreamAckTimeNanos) {
        this.proto = DataTransferProtos.PipelineAckProto.newBuilder().setSeqno(seqno).addAllStatus(Arrays.asList(replies)).setDownstreamAckTimeNanos(downstreamAckTimeNanos).build();
    }

    public long getSeqno() {
        return this.proto.getSeqno();
    }

    public short getNumOfReplies() {
        return (short)this.proto.getStatusCount();
    }

    public DataTransferProtos.Status getReply(int i) {
        return this.proto.getStatus(i);
    }

    public long getDownstreamAckTimeNanos() {
        return this.proto.getDownstreamAckTimeNanos();
    }

    public boolean isSuccess() {
        for (DataTransferProtos.Status reply : this.proto.getStatusList()) {
            if (reply == DataTransferProtos.Status.SUCCESS) continue;
            return false;
        }
        return true;
    }

    public DataTransferProtos.Status getOOBStatus() {
        if (this.getSeqno() != -2L) {
            return null;
        }
        for (DataTransferProtos.Status reply : this.proto.getStatusList()) {
            if (reply.getNumber() < 8 || reply.getNumber() > 11) continue;
            return reply;
        }
        return null;
    }

    public static long getOOBTimeout(DataTransferProtos.Status status) throws IOException {
        int index = status.getNumber() - 8;
        if (index >= 0 && index < 4) {
            return OOB_TIMEOUT[index];
        }
        throw new IOException("Not an OOB status: " + status);
    }

    public static DataTransferProtos.Status getRestartOOBStatus() {
        return DataTransferProtos.Status.OOB_RESTART;
    }

    public static boolean isRestartOOBStatus(DataTransferProtos.Status st) {
        return st.equals(DataTransferProtos.Status.OOB_RESTART);
    }

    public void readFields(InputStream in) throws IOException {
        this.proto = DataTransferProtos.PipelineAckProto.parseFrom(PBHelper.vintPrefixed(in));
    }

    public void write(OutputStream out) throws IOException {
        this.proto.writeDelimitedTo(out);
    }

    public String toString() {
        return TextFormat.shortDebugString(this.proto);
    }

    static {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] ele = conf.get("dfs.datanode.oob.timeout-ms", "1500,0,0,0").split(",");
        for (int i = 0; i < 4; ++i) {
            PipelineAck.OOB_TIMEOUT[i] = i < ele.length ? Long.valueOf(ele[i]) : 0L;
        }
    }
}

