/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeHttpServer;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeMXBean;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
public class JournalNode
implements Tool,
Configurable,
JournalNodeMXBean {
    public static final Log LOG = LogFactory.getLog(JournalNode.class);
    private Configuration conf;
    private JournalNodeRpcServer rpcServer;
    private JournalNodeHttpServer httpServer;
    private final Map<String, Journal> journalsById = Maps.newHashMap();
    private ObjectName journalNodeInfoBeanName;
    private String httpServerURI;
    private File localDir;
    private int resultCode = 0;

    synchronized Journal getOrCreateJournal(String jid, HdfsServerConstants.StartupOption startOpt) throws IOException {
        QuorumJournalManager.checkJournalId(jid);
        Journal journal = this.journalsById.get(jid);
        if (journal == null) {
            File logDir = this.getLogDir(jid);
            LOG.info("Initializing journal in directory " + logDir);
            journal = new Journal(this.conf, logDir, jid, startOpt, new ErrorReporter());
            this.journalsById.put(jid, journal);
        }
        return journal;
    }

    Journal getOrCreateJournal(String jid) throws IOException {
        return this.getOrCreateJournal(jid, HdfsServerConstants.StartupOption.REGULAR);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.localDir = new File(conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/").trim());
    }

    private static void validateAndCreateJournalDir(File dir) throws IOException {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Journal dir '" + dir + "' should be an absolute path");
        }
        DiskChecker.checkDir(dir);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int run(String[] args) throws Exception {
        this.start();
        return this.join();
    }

    public void start() throws IOException {
        Preconditions.checkState(!this.isStarted(), "JN already running");
        JournalNode.validateAndCreateJournalDir(this.localDir);
        DefaultMetricsSystem.initialize("JournalNode");
        JvmMetrics.create("JournalNode", this.conf.get("dfs.metrics.session-id"), DefaultMetricsSystem.instance());
        InetSocketAddress socAddr = JournalNodeRpcServer.getAddress(this.conf);
        SecurityUtil.login(this.conf, "dfs.journalnode.keytab.file", "dfs.journalnode.kerberos.principal", socAddr.getHostName());
        this.registerJNMXBean();
        this.httpServer = new JournalNodeHttpServer(this.conf, this);
        this.httpServer.start();
        this.httpServerURI = this.httpServer.getServerURI().toString();
        this.rpcServer = new JournalNodeRpcServer(this.conf, this);
        this.rpcServer.start();
    }

    public boolean isStarted() {
        return this.rpcServer != null;
    }

    public InetSocketAddress getBoundIpcAddress() {
        return this.rpcServer.getAddress();
    }

    @Deprecated
    public InetSocketAddress getBoundHttpAddress() {
        return this.httpServer.getAddress();
    }

    public String getHttpServerURI() {
        return this.httpServerURI;
    }

    public void stop(int rc) {
        this.resultCode = rc;
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (IOException ioe) {
                LOG.warn("Unable to stop HTTP server for " + this, ioe);
            }
        }
        for (Journal j : this.journalsById.values()) {
            IOUtils.cleanup(LOG, j);
        }
        if (this.journalNodeInfoBeanName != null) {
            MBeans.unregister(this.journalNodeInfoBeanName);
            this.journalNodeInfoBeanName = null;
        }
    }

    int join() throws InterruptedException {
        if (this.rpcServer != null) {
            this.rpcServer.join();
        }
        return this.resultCode;
    }

    public void stopAndJoin(int rc) throws InterruptedException {
        this.stop(rc);
        this.join();
    }

    private File getLogDir(String jid) {
        String dir = this.conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/");
        Preconditions.checkArgument(jid != null && !jid.isEmpty(), "bad journal identifier: %s", jid);
        return new File(new File(dir), jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJournalsStatus() {
        File[] journalDirs;
        HashMap status = new HashMap();
        JournalNode journalNode = this;
        synchronized (journalNode) {
            for (Map.Entry<String, Journal> entry : this.journalsById.entrySet()) {
                HashMap<String, String> jMap = new HashMap<String, String>();
                jMap.put("Formatted", Boolean.toString(entry.getValue().isFormatted()));
                status.put(entry.getKey(), jMap);
            }
        }
        for (File journalDir : journalDirs = this.localDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String jid = journalDir.getName();
            if (status.containsKey(jid)) continue;
            HashMap<String, String> jMap = new HashMap<String, String>();
            jMap.put("Formatted", "true");
            status.put(jid, jMap);
        }
        return JSON.toString(status);
    }

    private void registerJNMXBean() {
        this.journalNodeInfoBeanName = MBeans.register("JournalNode", "JournalNodeInfo", this);
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(JournalNode.class, args, LOG);
        System.exit(ToolRunner.run(new JournalNode(), args));
    }

    public void discardSegments(String journalId, long startTxId) throws IOException {
        this.getOrCreateJournal(journalId).discardSegments(startTxId);
    }

    public void doPreUpgrade(String journalId) throws IOException {
        this.getOrCreateJournal(journalId).doPreUpgrade();
    }

    public void doUpgrade(String journalId, StorageInfo sInfo) throws IOException {
        this.getOrCreateJournal(journalId).doUpgrade(sInfo);
    }

    public void doFinalize(String journalId) throws IOException {
        this.getOrCreateJournal(journalId).doFinalize();
    }

    public Boolean canRollBack(String journalId, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        return this.getOrCreateJournal(journalId, HdfsServerConstants.StartupOption.ROLLBACK).canRollBack(storage, prevStorage, targetLayoutVersion);
    }

    public void doRollback(String journalId) throws IOException {
        this.getOrCreateJournal(journalId, HdfsServerConstants.StartupOption.ROLLBACK).doRollback();
    }

    public Long getJournalCTime(String journalId) throws IOException {
        return this.getOrCreateJournal(journalId).getJournalCTime();
    }

    static {
        HdfsConfiguration.init();
    }

    private class ErrorReporter
    implements StorageErrorReporter {
        private ErrorReporter() {
        }

        @Override
        public void reportErrorOnFile(File f) {
            LOG.fatal("Error reported on file " + f + "... exiting", new Exception());
            JournalNode.this.stop(1);
        }
    }
}

