/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.IntrusiveCollection;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDescriptor
extends DatanodeInfo {
    public static final Log LOG = LogFactory.getLog(DatanodeDescriptor.class);
    public static final DatanodeDescriptor[] EMPTY_ARRAY = new DatanodeDescriptor[0];
    public final DecommissioningStatus decommissioningStatus = new DecommissioningStatus();
    private final Map<String, DatanodeStorageInfo> storageMap = new HashMap<String, DatanodeStorageInfo>();
    private final CachedBlocksList pendingCached = new CachedBlocksList(this, CachedBlocksList.Type.PENDING_CACHED);
    private final CachedBlocksList cached = new CachedBlocksList(this, CachedBlocksList.Type.CACHED);
    private final CachedBlocksList pendingUncached = new CachedBlocksList(this, CachedBlocksList.Type.PENDING_UNCACHED);
    private long lastCachingDirectiveSentTimeMs;
    public boolean isAlive = false;
    public boolean needKeyUpdate = false;
    private long bandwidth;
    private final BlockQueue<BlockTargetPair> replicateBlocks = new BlockQueue();
    private final BlockQueue<BlockInfoUnderConstruction> recoverBlocks = new BlockQueue();
    private final LightWeightHashSet<Block> invalidateBlocks = new LightWeightHashSet();
    private int currApproxBlocksScheduled = 0;
    private int prevApproxBlocksScheduled = 0;
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;
    private int volumeFailures = 0;
    private boolean disallowed = false;

    public CachedBlocksList getPendingCached() {
        return this.pendingCached;
    }

    public CachedBlocksList getCached() {
        return this.cached;
    }

    public CachedBlocksList getPendingUncached() {
        return this.pendingUncached;
    }

    public DatanodeDescriptor(DatanodeID nodeID) {
        super(nodeID);
        this.updateHeartbeat(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        super(nodeID, networkLocation);
        this.updateHeartbeat(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0);
    }

    public boolean addBlock(String storageID, BlockInfo b) {
        DatanodeStorageInfo s = this.getStorageInfo(storageID);
        if (s != null) {
            return s.addBlock(b);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public DatanodeStorageInfo getStorageInfo(String storageID) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            return this.storageMap.get(storageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeStorageInfo[] getStorageInfos() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            Collection<DatanodeStorageInfo> storages = this.storageMap.values();
            return storages.toArray(new DatanodeStorageInfo[storages.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasStaleStorages() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            for (DatanodeStorageInfo storage : this.storageMap.values()) {
                if (!storage.areBlockContentsStale()) continue;
                return true;
            }
            return false;
        }
    }

    boolean removeBlock(BlockInfo b) {
        DatanodeStorageInfo s;
        int index = b.findStorageInfo(this);
        if (index >= 0 && (s = b.getStorageInfo(index)) != null) {
            return s.removeBlock(b);
        }
        return false;
    }

    boolean removeBlock(String storageID, BlockInfo b) {
        DatanodeStorageInfo s = this.getStorageInfo(storageID);
        if (s != null) {
            return s.removeBlock(b);
        }
        return false;
    }

    public BlockInfo replaceBlock(BlockInfo oldBlock, BlockInfo newBlock) {
        int index = oldBlock.findStorageInfo(this);
        DatanodeStorageInfo s = oldBlock.getStorageInfo(index);
        boolean done = s.removeBlock(oldBlock);
        assert (done) : "Old block should belong to the data-node when replacing";
        done = s.addBlock(newBlock);
        assert (done) : "New block should not belong to the data-node when replacing";
        return newBlock;
    }

    public void resetBlocks() {
        this.setCapacity(0L);
        this.setRemaining(0L);
        this.setBlockPoolUsed(0L);
        this.setDfsUsed(0L);
        this.setXceiverCount(0);
        this.invalidateBlocks.clear();
        this.volumeFailures = 0;
        this.pendingCached.clear();
        this.cached.clear();
        this.pendingUncached.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockQueues() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            this.invalidateBlocks.clear();
            this.recoverBlocks.clear();
            this.replicateBlocks.clear();
        }
        this.pendingCached.clear();
        this.cached.clear();
        this.pendingUncached.clear();
    }

    public int numBlocks() {
        int blocks = 0;
        for (DatanodeStorageInfo entry : this.getStorageInfos()) {
            blocks += entry.numBlocks();
        }
        return blocks;
    }

    public void updateHeartbeat(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures) {
        long totalCapacity = 0L;
        long totalRemaining = 0L;
        long totalBlockPoolUsed = 0L;
        long totalDfsUsed = 0L;
        this.setCacheCapacity(cacheCapacity);
        this.setCacheUsed(cacheUsed);
        this.setXceiverCount(xceiverCount);
        this.setLastUpdate(Time.now());
        this.volumeFailures = volFailures;
        for (StorageReport report : reports) {
            DatanodeStorageInfo storage = this.updateStorage(report.getStorage());
            storage.receivedHeartbeat(report);
            totalCapacity += report.getCapacity();
            totalRemaining += report.getRemaining();
            totalBlockPoolUsed += report.getBlockPoolUsed();
            totalDfsUsed += report.getDfsUsed();
        }
        this.rollBlocksScheduled(this.getLastUpdate());
        this.setCapacity(totalCapacity);
        this.setRemaining(totalRemaining);
        this.setBlockPoolUsed(totalBlockPoolUsed);
        this.setDfsUsed(totalDfsUsed);
    }

    Iterator<BlockInfo> getBlockIterator() {
        return new BlockIterator(this.getStorageInfos());
    }

    Iterator<BlockInfo> getBlockIterator(String storageID) {
        return new BlockIterator(new DatanodeStorageInfo[]{this.getStorageInfo(storageID)});
    }

    void addBlockToBeReplicated(Block block, DatanodeStorageInfo[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(new BlockTargetPair(block, targets));
    }

    void addBlockToBeRecovered(BlockInfoUnderConstruction block) {
        if (this.recoverBlocks.contains(block)) {
            BlockManager.LOG.info(block + " is already in the recovery queue");
            return;
        }
        this.recoverBlocks.offer(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.replicateBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            return this.invalidateBlocks.size();
        }
    }

    public List<BlockTargetPair> getReplicationCommand(int maxTransfers) {
        return this.replicateBlocks.poll(maxTransfers);
    }

    public BlockInfoUnderConstruction[] getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockInfoUnderConstruction> blocks = this.recoverBlocks.poll(maxTransfers);
        if (blocks == null) {
            return null;
        }
        return blocks.toArray(new BlockInfoUnderConstruction[blocks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] getInvalidateBlocks(int maxblocks) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            Block[] deleteList = this.invalidateBlocks.pollToArray((Block[])new Block[Math.min(this.invalidateBlocks.size(), maxblocks)]);
            return deleteList.length == 0 ? null : deleteList;
        }
    }

    public int getBlocksScheduled() {
        return this.currApproxBlocksScheduled + this.prevApproxBlocksScheduled;
    }

    void incrementBlocksScheduled() {
        ++this.currApproxBlocksScheduled;
    }

    void decrementBlocksScheduled() {
        if (this.prevApproxBlocksScheduled > 0) {
            --this.prevApproxBlocksScheduled;
        } else if (this.currApproxBlocksScheduled > 0) {
            --this.currApproxBlocksScheduled;
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled = this.currApproxBlocksScheduled;
            this.currApproxBlocksScheduled = 0;
            this.lastBlocksScheduledRollTime = now;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public void setDisallowed(boolean flag) {
        this.disallowed = flag;
    }

    public boolean isDisallowed() {
        return this.disallowed;
    }

    public int getVolumeFailures() {
        return this.volumeFailures;
    }

    @Override
    public void updateRegInfo(DatanodeID nodeReg) {
        super.updateRegInfo(nodeReg);
        for (DatanodeStorageInfo storage : this.getStorageInfos()) {
            storage.setBlockReportCount(0);
        }
    }

    public long getBalancerBandwidth() {
        return this.bandwidth;
    }

    public void setBalancerBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public String dumpDatanode() {
        int recover;
        int inval;
        StringBuilder sb = new StringBuilder(super.dumpDatanode());
        int repl = this.replicateBlocks.size();
        if (repl > 0) {
            sb.append(" ").append(repl).append(" blocks to be replicated;");
        }
        if ((inval = this.invalidateBlocks.size()) > 0) {
            sb.append(" ").append(inval).append(" blocks to be invalidated;");
        }
        if ((recover = this.recoverBlocks.size()) > 0) {
            sb.append(" ").append(recover).append(" blocks to be recovered;");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeStorageInfo updateStorage(DatanodeStorage s) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            DatanodeStorageInfo storage = this.storageMap.get(s.getStorageID());
            if (storage == null) {
                LOG.info("Adding new storage ID " + s.getStorageID() + " for DN " + this.getXferAddr());
                storage = new DatanodeStorageInfo(this, s);
                this.storageMap.put(s.getStorageID(), storage);
            } else if (storage.getState() != s.getState() || storage.getStorageType() != s.getStorageType()) {
                storage.updateFromStorage(s);
                this.storageMap.put(storage.getStorageID(), storage);
            }
            return storage;
        }
    }

    public long getLastCachingDirectiveSentTimeMs() {
        return this.lastCachingDirectiveSentTimeMs;
    }

    public void setLastCachingDirectiveSentTimeMs(long time) {
        this.lastCachingDirectiveSentTimeMs = time;
    }

    public class DecommissioningStatus {
        private int underReplicatedBlocks;
        private int decommissionOnlyReplicas;
        private int underReplicatedInOpenFiles;
        private long startTime;

        synchronized void set(int underRep, int onlyRep, int underConstruction) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return;
            }
            this.underReplicatedBlocks = underRep;
            this.decommissionOnlyReplicas = onlyRep;
            this.underReplicatedInOpenFiles = underConstruction;
        }

        public synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        public synchronized int getDecommissionOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.decommissionOnlyReplicas;
        }

        public synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedInOpenFiles;
        }

        public synchronized void setStartTime(long time) {
            this.startTime = time;
        }

        public synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    private static class BlockIterator
    implements Iterator<BlockInfo> {
        private int index = 0;
        private final List<Iterator<BlockInfo>> iterators;

        private BlockIterator(DatanodeStorageInfo ... storages) {
            ArrayList<Iterator<BlockInfo>> iterators = new ArrayList<Iterator<BlockInfo>>();
            for (DatanodeStorageInfo e : storages) {
                iterators.add(e.getBlockIterator());
            }
            this.iterators = Collections.unmodifiableList(iterators);
        }

        @Override
        public boolean hasNext() {
            this.update();
            return !this.iterators.isEmpty() && this.iterators.get(this.index).hasNext();
        }

        @Override
        public BlockInfo next() {
            this.update();
            return this.iterators.get(this.index).next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported.");
        }

        private void update() {
            while (this.index < this.iterators.size() - 1 && !this.iterators.get(this.index).hasNext()) {
                ++this.index;
            }
        }
    }

    public static class CachedBlocksList
    extends IntrusiveCollection<CachedBlock> {
        private final DatanodeDescriptor datanode;
        private final Type type;

        CachedBlocksList(DatanodeDescriptor datanode, Type type) {
            this.datanode = datanode;
            this.type = type;
        }

        public DatanodeDescriptor getDatanode() {
            return this.datanode;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            PENDING_CACHED,
            CACHED,
            PENDING_UNCACHED;

        }
    }

    private static class BlockQueue<E> {
        private final Queue<E> blockq = new LinkedList();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(E e) {
            return this.blockq.offer(e);
        }

        synchronized List<E> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<E> results = new ArrayList<E>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }

        boolean contains(E e) {
            return this.blockq.contains(e);
        }

        synchronized void clear() {
            this.blockq.clear();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeStorageInfo[] targets;

        BlockTargetPair(Block block, DatanodeStorageInfo[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

