/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;

class FsVolumeList {
    volatile List<FsVolumeImpl> volumes = null;
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private volatile int numFailedVolumes;

    FsVolumeList(List<FsVolumeImpl> volumes, int failedVols, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.volumes = Collections.unmodifiableList(volumes);
        this.blockChooser = blockChooser;
        this.numFailedVolumes = failedVols;
    }

    int numberOfFailedVolumes() {
        return this.numFailedVolumes;
    }

    synchronized FsVolumeImpl getNextVolume(long blockSize) throws IOException {
        return this.blockChooser.chooseVolume(this.volumes, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getDfsUsed();
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getBlockPoolUsed(bpid);
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes) {
            capacity += v.getCapacity();
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeImpl vol : this.volumes) {
            remaining += vol.getAvailable();
        }
        return remaining;
    }

    void initializeReplicaMaps(ReplicaMap globalReplicaMap) throws IOException {
        for (FsVolumeImpl v : this.volumes) {
            v.getVolumeMap(globalReplicaMap);
        }
    }

    void getAllVolumesMap(final String bpid, final ReplicaMap volumeMap) throws IOException {
        long totalStartTime = System.currentTimeMillis();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<1> replicaAddingThreads = new ArrayList<1>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info("Adding replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + "...");
                        long startTime = System.currentTimeMillis();
                        fsVolumeImpl.getVolumeMap(bpid, volumeMap);
                        long timeTaken = System.currentTimeMillis() - startTime;
                        FsDatasetImpl.LOG.info("Time to add replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + ": " + timeTaken + "ms");
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info("Caught exception while adding replicas from " + fsVolumeImpl + ". Will throw later.", ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            replicaAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : replicaAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = System.currentTimeMillis() - totalStartTime;
        FsDatasetImpl.LOG.info("Total time to add all replicas to map: " + totalTimeTaken + "ms");
    }

    void getVolumeMap(String bpid, FsVolumeImpl volume, ReplicaMap volumeMap) throws IOException {
        FsDatasetImpl.LOG.info("Adding replicas to map for block pool " + bpid + " on volume " + volume + "...");
        long startTime = System.currentTimeMillis();
        volume.getVolumeMap(bpid, volumeMap);
        long timeTaken = System.currentTimeMillis() - startTime;
        FsDatasetImpl.LOG.info("Time to add replicas to map for block pool " + bpid + " on volume " + volume + ": " + timeTaken + "ms");
    }

    synchronized List<FsVolumeImpl> checkDirs() {
        ArrayList<FsVolumeImpl> removedVols = null;
        ArrayList<FsVolumeImpl> volumeList = new ArrayList<FsVolumeImpl>(this.volumes);
        Iterator i = volumeList.iterator();
        while (i.hasNext()) {
            FsVolumeImpl fsv = (FsVolumeImpl)i.next();
            try {
                fsv.checkDirs();
            }
            catch (DiskChecker.DiskErrorException e) {
                FsDatasetImpl.LOG.warn("Removing failed volume " + fsv + ": ", e);
                if (removedVols == null) {
                    removedVols = new ArrayList<FsVolumeImpl>(1);
                }
                removedVols.add(fsv);
                fsv.shutdown();
                i.remove();
                ++this.numFailedVolumes;
            }
        }
        if (removedVols != null && removedVols.size() > 0) {
            this.volumes = Collections.unmodifiableList(volumeList);
            FsDatasetImpl.LOG.warn("Completed checkDirs. Removed " + removedVols.size() + " volumes. Current volumes: " + this);
        }
        return removedVols;
    }

    public String toString() {
        return this.volumes.toString();
    }

    void addBlockPool(final String bpid, final Configuration conf) throws IOException {
        long totalStartTime = System.currentTimeMillis();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<2> blockPoolAddingThreads = new ArrayList<2>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info("Scanning block pool " + bpid + " on volume " + fsVolumeImpl + "...");
                        long startTime = System.currentTimeMillis();
                        fsVolumeImpl.addBlockPool(bpid, conf);
                        long timeTaken = System.currentTimeMillis() - startTime;
                        FsDatasetImpl.LOG.info("Time taken to scan block pool " + bpid + " on " + fsVolumeImpl + ": " + timeTaken + "ms");
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info("Caught exception while scanning " + fsVolumeImpl + ". Will throw later.", ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            blockPoolAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : blockPoolAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = System.currentTimeMillis() - totalStartTime;
        FsDatasetImpl.LOG.info("Total time to scan all replicas for block pool " + bpid + ": " + totalTimeTaken + "ms");
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

