/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.znerd.xmlenc.XMLOutputter;

class NamenodeJspHelper {
    NamenodeJspHelper() {
    }

    static String fraction2String(double value) {
        return StringUtils.format("%.2f", value);
    }

    static String fraction2String(long numerator, long denominator) {
        return NamenodeJspHelper.fraction2String((double)numerator / (double)denominator);
    }

    static String getSafeModeText(FSNamesystem fsn) {
        if (fsn == null || !fsn.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. <em>" + fsn.getSafeModeTip() + "</em><br>";
    }

    static String getSecurityModeText() {
        if (UserGroupInformation.isSecurityEnabled()) {
            return "<div class=\"security\">Security is <em>ON</em></div>";
        }
        return "<div class=\"security\">Security is <em>OFF</em></div>";
    }

    static String getRollingUpgradeText(FSNamesystem fsn) {
        if (fsn == null) {
            return "";
        }
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        HashMap<String, Integer> list = dm.getDatanodesSoftwareVersions();
        if (list.size() > 1) {
            StringBuffer status = new StringBuffer("Rolling upgrades in progress. There are " + list.size() + " versions of datanodes currently live: ");
            for (Map.Entry ver : list.entrySet()) {
                status.append((String)ver.getKey() + "(" + ver.getValue() + "), ");
            }
            return status.substring(0, status.length() - 2);
        }
        return "";
    }

    static String getInodeLimitText(FSNamesystem fsn) {
        if (fsn == null) {
            return "";
        }
        long inodes = fsn.dir.totalInodes();
        long blocks = fsn.getBlocksTotal();
        long maxobjects = fsn.getMaxObjects();
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = mem.getHeapMemoryUsage();
        long totalMemory = heap.getUsed();
        long maxMemory = heap.getMax();
        long commitedMemory = heap.getCommitted();
        MemoryUsage nonHeap = mem.getNonHeapMemoryUsage();
        long totalNonHeap = nonHeap.getUsed();
        long maxNonHeap = nonHeap.getMax();
        long commitedNonHeap = nonHeap.getCommitted();
        long used = totalMemory * 100L / commitedMemory;
        long usedNonHeap = totalNonHeap * 100L / commitedNonHeap;
        String str = "<div>" + inodes + " files and directories, " + blocks + " blocks = " + (inodes + blocks) + " total";
        if (maxobjects != 0L) {
            long pct = (inodes + blocks) * 100L / maxobjects;
            str = str + " / " + maxobjects + " (" + pct + "%)";
        }
        str = str + ".</div>";
        str = str + "<div>Heap Memory used " + StringUtils.byteDesc(totalMemory) + " is " + " " + used + "% of Commited Heap Memory " + StringUtils.byteDesc(commitedMemory) + ". Max Heap Memory is " + StringUtils.byteDesc(maxMemory) + ". </div>";
        str = str + "<div>Non Heap Memory used " + StringUtils.byteDesc(totalNonHeap) + " is" + " " + usedNonHeap + "% of " + " Commited Non Heap Memory " + StringUtils.byteDesc(commitedNonHeap) + ". Max Non Heap Memory is " + StringUtils.byteDesc(maxNonHeap) + ".</div>";
        return str;
    }

    static String getVersionTable(FSNamesystem fsn) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='dfstable'><table>");
        if (fsn != null) {
            sb.append("\n  <tr><td class='col1'>Started:</td><td>" + fsn.getStartTime());
        }
        sb.append("</td></tr>\n\n  <tr><td class='col1'>Version:</td><td>");
        sb.append(VersionInfo.getVersion() + ", " + VersionInfo.getRevision());
        sb.append("</td></tr>\n\n  <tr><td class='col1'>Compiled:</td><td>" + VersionInfo.getDate());
        sb.append(" by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch());
        if (fsn != null) {
            sb.append("</td></tr>\n  <tr><td class='col1'>Cluster ID:</td><td>" + fsn.getClusterId());
            sb.append("</td></tr>\n  <tr><td class='col1'>Block Pool ID:</td><td>" + fsn.getBlockPoolId());
        }
        sb.append("</td></tr>\n</table></div>");
        return sb.toString();
    }

    static String getCorruptFilesWarning(FSNamesystem fsn) {
        if (fsn == null) {
            return "";
        }
        long missingBlocks = fsn.getMissingBlocksCount();
        if (missingBlocks > 0L) {
            StringBuilder result = new StringBuilder();
            result.append("<div>");
            result.append("<a class=\"warning\" href=\"/corrupt_files.jsp\" title=\"List corrupt files\">\n");
            result.append("<b>WARNING : There are " + missingBlocks + " missing blocks. Please check the logs or run fsck in order to identify the missing blocks.</b>");
            result.append("</a>");
            result.append("<div class=\"small\">See the Hadoop FAQ for common causes and potential solutions.</div>");
            result.append("</div>\n");
            return result.toString();
        }
        return "";
    }

    static void generateSnapshotReport(JspWriter out, FSNamesystem fsn) throws IOException {
        if (fsn == null) {
            return;
        }
        out.println("<div id=\"snapshotstats\"><div class=\"dfstable\"><table class=\"storage\" title=\"Snapshot Summary\">\n<thead><tr><td><b>Snapshottable directories</b></td><td><b>Snapshotted directories</b></td></tr></thead>");
        out.println(String.format("<td>%d</td><td>%d</td>", fsn.getNumSnapshottableDirs(), fsn.getNumSnapshots()));
        out.println("</table></div></div>");
    }

    static String getDelegationToken(final NamenodeProtocols nn, HttpServletRequest request, Configuration conf, final UserGroupInformation ugi) throws IOException, InterruptedException {
        Token<DelegationTokenIdentifier> token = ugi.doAs(new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

            @Override
            public Token<DelegationTokenIdentifier> run() throws IOException {
                return nn.getDelegationToken(new Text(ugi.getUserName()));
            }
        });
        return token == null ? null : token.encodeToUrlString();
    }

    static DatanodeDescriptor getRandomDatanode(NameNode namenode) {
        return (DatanodeDescriptor)namenode.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology().chooseRandom("");
    }

    static void redirectToRandomDataNode(ServletContext context, HttpServletRequest request, HttpServletResponse resp) throws IOException, InterruptedException {
        NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        Configuration conf = (Configuration)context.getAttribute("current.conf");
        FSNamesystem fsn = nn.getNamesystem();
        DatanodeDescriptor datanode = null;
        if (fsn != null && fsn.getNumLiveDataNodes() >= 1) {
            datanode = NamenodeJspHelper.getRandomDatanode(nn);
        }
        if (datanode == null) {
            throw new IOException("Can't browse the DFS since there are no live nodes available to redirect to.");
        }
        UserGroupInformation ugi = JspHelper.getUGI(context, request, conf);
        String tokenString = NamenodeJspHelper.getDelegationToken(nn.getRpcServer(), request, conf, ugi);
        InetSocketAddress rpcAddr = nn.getNameNodeAddress();
        String rpcHost = rpcAddr.getAddress().isAnyLocalAddress() ? URI.create(request.getRequestURL().toString()).getHost() : rpcAddr.getAddress().getHostAddress();
        String addr = rpcHost + ":" + rpcAddr.getPort();
        String redirectLocation = JspHelper.Url.url(request.getScheme(), datanode) + "/browseDirectory.jsp?namenodeInfoPort=" + request.getServerPort() + "&dir=/" + (tokenString == null ? "" : JspHelper.getDelegationTokenUrlParam(tokenString)) + JspHelper.getUrlParam("nnaddr", addr);
        resp.sendRedirect(redirectLocation);
    }

    static String getNameNodeLabel(NameNode nn) {
        return nn.getRpcServer() != null ? nn.getNameNodeAddressHostPortString() : "initializing";
    }

    private static String getLocalParentDir(INode inode) {
        INode parent = inode.isRoot() ? inode : inode.getParent();
        String parentDir = "";
        if (parent != null) {
            parentDir = parent.getFullPathName();
        }
        return parentDir != null ? parentDir : "";
    }

    static class XMLCorruptBlockInfo {
        final Configuration conf;
        final Long startingBlockId;
        final int numCorruptBlocks;
        final BlockManager blockManager;

        XMLCorruptBlockInfo(FSNamesystem fsn, Configuration conf, int numCorruptBlocks, Long startingBlockId) {
            this.blockManager = fsn != null ? fsn.getBlockManager() : null;
            this.conf = conf;
            this.numCorruptBlocks = numCorruptBlocks;
            this.startingBlockId = startingBlockId;
        }

        public void toXML(XMLOutputter doc) throws IOException {
            long[] corruptBlockIds;
            doc.startTag("corrupt_block_info");
            if (this.numCorruptBlocks < 0 || this.numCorruptBlocks > 100) {
                doc.startTag("error");
                doc.pcdata("numCorruptBlocks must be >= 0 and <= 100");
                doc.endTag();
            }
            doc.startTag("dfs.replication");
            doc.pcdata("" + this.conf.getInt("dfs.replication", 3));
            doc.endTag();
            doc.startTag("num_missing_blocks");
            doc.pcdata("" + (this.blockManager != null ? this.blockManager.getMissingBlocksCount() : 0L));
            doc.endTag();
            doc.startTag("num_corrupt_replica_blocks");
            doc.pcdata("" + (this.blockManager != null ? this.blockManager.getCorruptReplicaBlocksCount() : 0L));
            doc.endTag();
            doc.startTag("corrupt_replica_block_ids");
            long[] lArray = corruptBlockIds = this.blockManager != null ? this.blockManager.getCorruptReplicaBlockIds(this.numCorruptBlocks, this.startingBlockId) : null;
            if (corruptBlockIds != null) {
                long[] arr$ = corruptBlockIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Long blockId = arr$[i$];
                    doc.startTag("block_id");
                    doc.pcdata("" + blockId);
                    doc.endTag();
                }
            }
            doc.endTag();
            doc.endTag();
            doc.getWriter().flush();
        }
    }

    static class XMLBlockInfo {
        final Block block;
        final INodeFile inode;
        final BlockManager blockManager;

        XMLBlockInfo(FSNamesystem fsn, Long blockId) {
            BlockManager blockManager = this.blockManager = fsn != null ? fsn.getBlockManager() : null;
            if (blockId == null) {
                this.block = null;
                this.inode = null;
            } else {
                this.block = new Block(blockId);
                this.inode = this.blockManager != null ? ((INode)((Object)this.blockManager.getBlockCollection(this.block))).asFile() : null;
            }
        }

        public void toXML(XMLOutputter doc) throws IOException {
            doc.startTag("block_info");
            if (this.block == null) {
                doc.startTag("error");
                doc.pcdata("blockId must be a Long");
                doc.endTag();
            } else {
                doc.startTag("block_id");
                doc.pcdata("" + this.block.getBlockId());
                doc.endTag();
                doc.startTag("block_name");
                doc.pcdata(this.block.getBlockName());
                doc.endTag();
                if (this.inode != null) {
                    doc.startTag("file");
                    doc.startTag("local_name");
                    doc.pcdata(this.inode.getLocalName());
                    doc.endTag();
                    doc.startTag("local_directory");
                    doc.pcdata(NamenodeJspHelper.getLocalParentDir(this.inode));
                    doc.endTag();
                    doc.startTag("user_name");
                    doc.pcdata(this.inode.getUserName());
                    doc.endTag();
                    doc.startTag("group_name");
                    doc.pcdata(this.inode.getGroupName());
                    doc.endTag();
                    doc.startTag("is_directory");
                    doc.pcdata("" + this.inode.isDirectory());
                    doc.endTag();
                    doc.startTag("access_time");
                    doc.pcdata("" + this.inode.getAccessTime());
                    doc.endTag();
                    doc.startTag("is_under_construction");
                    doc.pcdata("" + this.inode.isUnderConstruction());
                    doc.endTag();
                    doc.startTag("ds_quota");
                    doc.pcdata("" + this.inode.getQuotaCounts().get(Quota.DISKSPACE));
                    doc.endTag();
                    doc.startTag("permission_status");
                    doc.pcdata(this.inode.getPermissionStatus().toString());
                    doc.endTag();
                    doc.startTag("replication");
                    doc.pcdata("" + this.inode.getFileReplication());
                    doc.endTag();
                    doc.startTag("disk_space_consumed");
                    doc.pcdata("" + this.inode.diskspaceConsumed());
                    doc.endTag();
                    doc.startTag("preferred_block_size");
                    doc.pcdata("" + this.inode.getPreferredBlockSize());
                    doc.endTag();
                    doc.endTag();
                }
                doc.startTag("replicas");
                for (DatanodeStorageInfo storage : this.blockManager != null ? this.blockManager.getStorages(this.block) : Collections.emptyList()) {
                    doc.startTag("replica");
                    DatanodeDescriptor dd = storage.getDatanodeDescriptor();
                    doc.startTag("host_name");
                    doc.pcdata(dd.getHostName());
                    doc.endTag();
                    boolean isCorrupt = this.blockManager.getCorruptReplicaBlockIds(0, this.block.getBlockId()) != null;
                    doc.startTag("is_corrupt");
                    doc.pcdata("" + isCorrupt);
                    doc.endTag();
                    doc.endTag();
                }
                doc.endTag();
            }
            doc.endTag();
        }
    }

    static class NodeListJsp {
        private int rowNum = 0;
        private long diskBytes = 0x40000000L;
        private String diskByteStr = "GB";
        private String sorterField = null;
        private String sorterOrder = null;
        private String whatNodes = "LIVE";

        NodeListJsp() {
        }

        private String rowTxt() {
            return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
        }

        private void counterReset() {
            this.rowNum = 0;
        }

        private String nodeHeaderStr(String name) {
            String ret = "class=header";
            String order = "ASC";
            if (name.equals(this.sorterField)) {
                ret = ret + this.sorterOrder;
                if (this.sorterOrder.equals("ASC")) {
                    order = "DSC";
                }
            }
            ret = ret + " onClick=\"window.document.location='/dfsnodelist.jsp?whatNodes=" + this.whatNodes + "&sorter/field=" + name + "&sorter/order=" + order + "'\" title=\"sort on this column\"";
            return ret;
        }

        private void generateNodeDataHeader(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnInfoPort, String nnaddr, String scheme) throws IOException {
            String url = "///" + JspHelper.Url.authority(scheme, d) + "/browseDirectory.jsp?namenodeInfoPort=" + nnInfoPort + "&dir=" + URLEncoder.encode("/", "UTF-8") + JspHelper.getUrlParam("nnaddr", nnaddr);
            String name = d.getXferAddrWithHostname();
            if (!name.matches("\\d+\\.\\d+.\\d+\\.\\d+.*")) {
                name = name.replaceAll("\\.[^.:]*", "");
            }
            int idx = suffix != null && name.endsWith(suffix) ? name.indexOf(suffix) : -1;
            out.print(this.rowTxt() + "<td class=\"name\"> <a title=\"" + url + "\" href=\"" + url + "\">" + (idx > 0 ? name.substring(0, idx) : name) + "</a>" + (alive ? "" : "\n") + "<td class=\"address\">" + d.getXferAddr());
        }

        void generateDecommissioningNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnInfoPort, String nnaddr, String scheme) throws IOException {
            this.generateNodeDataHeader(out, d, suffix, alive, nnInfoPort, nnaddr, scheme);
            if (!alive) {
                return;
            }
            long decommRequestTime = d.decommissioningStatus.getStartTime();
            long timestamp = d.getLastUpdate();
            long currentTime = Time.now();
            long hoursSinceDecommStarted = (currentTime - decommRequestTime) / 3600000L;
            long remainderMinutes = (currentTime - decommRequestTime) / 60000L % 60L;
            out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"underreplicatedblocks\">" + d.decommissioningStatus.getUnderReplicatedBlocks() + "<td class=\"blockswithonlydecommissioningreplicas\">" + d.decommissioningStatus.getDecommissionOnlyReplicas() + "<td class=\"underrepblocksinfilesunderconstruction\">" + d.decommissioningStatus.getUnderReplicatedInOpenFiles() + "<td class=\"timesincedecommissionrequest\">" + hoursSinceDecommStarted + " hrs " + remainderMinutes + " mins" + "\n");
        }

        void generateNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnInfoPort, String nnaddr, String scheme) throws IOException {
            this.generateNodeDataHeader(out, d, suffix, alive, nnInfoPort, nnaddr, scheme);
            if (!alive) {
                out.print("<td class=\"decommissioned\"> " + d.isDecommissioned() + "\n");
                return;
            }
            long c = d.getCapacity();
            long u = d.getDfsUsed();
            long nu = d.getNonDfsUsed();
            long r = d.getRemaining();
            double percentUsedValue = d.getDfsUsedPercent();
            String percentUsed = NamenodeJspHelper.fraction2String(percentUsedValue);
            String percentRemaining = NamenodeJspHelper.fraction2String(d.getRemainingPercent());
            String adminState = d.getAdminState().toString();
            long timestamp = d.getLastUpdate();
            long currentTime = Time.now();
            long bpUsed = d.getBlockPoolUsed();
            String percentBpUsed = NamenodeJspHelper.fraction2String(d.getBlockPoolUsedPercent());
            out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"adminstate\">" + adminState + "<td align=\"right\" class=\"capacity\">" + NamenodeJspHelper.fraction2String(c, this.diskBytes) + "<td align=\"right\" class=\"used\">" + NamenodeJspHelper.fraction2String(u, this.diskBytes) + "<td align=\"right\" class=\"nondfsused\">" + NamenodeJspHelper.fraction2String(nu, this.diskBytes) + "<td align=\"right\" class=\"remaining\">" + NamenodeJspHelper.fraction2String(r, this.diskBytes) + "<td align=\"right\" class=\"pcused\">" + percentUsed + "<td class=\"pcused\">" + ServletUtil.percentageGraph((int)percentUsedValue, 100) + "<td align=\"right\" class=\"pcremaining\">" + percentRemaining + "<td title=" + "\"blocks scheduled : " + d.getBlocksScheduled() + "\" class=\"blocks\">" + d.numBlocks() + "\n" + "<td align=\"right\" class=\"bpused\">" + NamenodeJspHelper.fraction2String(bpUsed, this.diskBytes) + "<td align=\"right\" class=\"pcbpused\">" + percentBpUsed + "<td align=\"right\" class=\"volfails\">" + d.getVolumeFailures() + "<td align=\"right\" class=\"version\">" + d.getSoftwareVersion() + "\n");
        }

        void generateNodesList(ServletContext context, JspWriter out, HttpServletRequest request) throws IOException {
            int i;
            NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
            FSNamesystem ns = nn.getNamesystem();
            if (ns == null) {
                return;
            }
            DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            dm.fetchDatanodes(live, dead, true);
            String nnaddr = nn.getServiceRpcAddress().getAddress().getHostName() + ":" + nn.getServiceRpcAddress().getPort();
            this.whatNodes = request.getParameter("whatNodes");
            if (null == this.whatNodes || this.whatNodes.isEmpty()) {
                out.print("Invalid input");
                return;
            }
            this.sorterField = request.getParameter("sorter/field");
            this.sorterOrder = request.getParameter("sorter/order");
            if (this.sorterField == null) {
                this.sorterField = "name";
            }
            if (this.sorterOrder == null) {
                this.sorterOrder = "ASC";
            }
            JspHelper.sortNodeList(live, this.sorterField, this.sorterOrder);
            String port_suffix = null;
            if (live.size() > 0) {
                String name = ((DatanodeDescriptor)live.get(0)).getXferAddr();
                int idx = name.indexOf(58);
                if (idx > 0) {
                    port_suffix = name.substring(idx);
                }
                for (i = 1; port_suffix != null && i < live.size(); ++i) {
                    if (((DatanodeDescriptor)live.get(i)).getXferAddr().endsWith(port_suffix)) continue;
                    port_suffix = null;
                    break;
                }
            }
            this.counterReset();
            if (live.isEmpty() && dead.isEmpty()) {
                out.print("There are no datanodes in the cluster");
            } else {
                int i2;
                int nnInfoPort = request.getServerPort();
                out.print("<div id=\"dfsnodetable\"> ");
                if (this.whatNodes.equals("LIVE")) {
                    out.print("<a name=\"LiveNodes\" id=\"title\">Live Datanodes : " + live.size() + "</a>" + "<br><br>\n<table class=\"nodes\">\n");
                    this.counterReset();
                    if (live.size() > 0) {
                        if (((DatanodeDescriptor)live.get(0)).getCapacity() > 1024L * this.diskBytes) {
                            this.diskBytes *= 1024L;
                            this.diskByteStr = "TB";
                        }
                        out.print("<tr class=\"headerRow\"> <th " + this.nodeHeaderStr("name") + "> Node <th " + this.nodeHeaderStr("address") + "> Transferring<br>Address <th " + this.nodeHeaderStr("lastcontact") + "> Last <br>Contact <th " + this.nodeHeaderStr("adminstate") + "> Admin State <th " + this.nodeHeaderStr("capacity") + "> Configured <br>Capacity (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("used") + "> Used <br>(" + this.diskByteStr + ") <th " + this.nodeHeaderStr("nondfsused") + "> Non DFS <br>Used (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("remaining") + "> Remaining <br>(" + this.diskByteStr + ") <th " + this.nodeHeaderStr("pcused") + "> Used <br>(%) <th " + this.nodeHeaderStr("pcused") + "> Used <br>(%) <th " + this.nodeHeaderStr("pcremaining") + "> Remaining <br>(%) <th " + this.nodeHeaderStr("blocks") + "> Blocks <th " + this.nodeHeaderStr("bpused") + "> Block Pool<br>Used (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("pcbpused") + "> Block Pool<br>Used (%)" + " <th " + this.nodeHeaderStr("volfails") + "> Failed Volumes <th " + this.nodeHeaderStr("versionString") + "> Version\n");
                        JspHelper.sortNodeList(live, this.sorterField, this.sorterOrder);
                        for (i2 = 0; i2 < live.size(); ++i2) {
                            this.generateNodeData(out, (DatanodeDescriptor)live.get(i2), port_suffix, true, nnInfoPort, nnaddr, request.getScheme());
                        }
                    }
                    out.print("</table>\n");
                } else if (this.whatNodes.equals("DEAD")) {
                    out.print("<br> <a name=\"DeadNodes\" id=\"title\">  Dead Datanodes : " + dead.size() + "</a><br><br>\n");
                    if (dead.size() > 0) {
                        out.print("<table border=1 cellspacing=0> <tr id=\"row1\"> <th " + this.nodeHeaderStr("node") + "> Node <th " + this.nodeHeaderStr("address") + "> Transferring<br>Address <th " + this.nodeHeaderStr("decommissioned") + "> Decommissioned\n");
                        JspHelper.sortNodeList(dead, this.sorterField, this.sorterOrder);
                        for (i2 = 0; i2 < dead.size(); ++i2) {
                            this.generateNodeData(out, (DatanodeDescriptor)dead.get(i2), port_suffix, false, nnInfoPort, nnaddr, request.getScheme());
                        }
                        out.print("</table>\n");
                    }
                } else if (this.whatNodes.equals("DECOMMISSIONING")) {
                    List<DatanodeDescriptor> decommissioning = dm.getDecommissioningNodes();
                    out.print("<br> <a name=\"DecommissioningNodes\" id=\"title\">  Decommissioning Datanodes : " + decommissioning.size() + "</a><br><br>\n");
                    if (decommissioning.size() > 0) {
                        out.print("<table border=1 cellspacing=0> <tr class=\"headRow\"> <th " + this.nodeHeaderStr("name") + "> Node <th " + this.nodeHeaderStr("address") + "> Transferring<br>Address <th " + this.nodeHeaderStr("lastcontact") + "> Last <br>Contact <th " + this.nodeHeaderStr("underreplicatedblocks") + "> Under Replicated Blocks <th " + this.nodeHeaderStr("blockswithonlydecommissioningreplicas") + "> Blocks With No <br> Live Replicas <th " + this.nodeHeaderStr("underrepblocksinfilesunderconstruction") + "> Under Replicated Blocks <br> In Files Under Construction" + " <th " + this.nodeHeaderStr("timesincedecommissionrequest") + "> Time Since Decommissioning Started");
                        JspHelper.sortNodeList(decommissioning, "name", "ASC");
                        for (i = 0; i < decommissioning.size(); ++i) {
                            this.generateDecommissioningNodeData(out, decommissioning.get(i), port_suffix, true, nnInfoPort, nnaddr, request.getScheme());
                        }
                        out.print("</table>\n");
                    }
                } else {
                    out.print("Invalid input");
                }
                out.print("</div>");
            }
        }
    }

    static class HealthJsp {
        private int rowNum = 0;
        private int colNum = 0;
        private String sorterField = null;
        private String sorterOrder = null;

        HealthJsp() {
        }

        private String rowTxt() {
            this.colNum = 0;
            return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
        }

        private String colTxt() {
            return "<td id=\"col" + ++this.colNum + "\"> ";
        }

        private String colTxt(String title) {
            return "<td id=\"col" + ++this.colNum + "\" title=\"" + title + "\"> ";
        }

        private void counterReset() {
            this.colNum = 0;
            this.rowNum = 0;
        }

        void generateConfReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
            FSNamesystem fsn = nn.getNamesystem();
            if (fsn == null) {
                return;
            }
            FSImage fsImage = fsn.getFSImage();
            List<Storage.StorageDirectory> removedStorageDirs = fsImage.getStorage().getRemovedStorageDirs();
            out.print("<h3> " + (Object)((Object)nn.getRole()) + " Storage: </h3>");
            out.print("<div class=\"dfstable\"> <table class=\"storage\" title=\"NameNode Storage\">\n<thead><tr><td><b>Storage Directory</b></td><td><b>Type</b></td><td><b>State</b></td></tr></thead>");
            Storage.StorageDirectory st = null;
            Iterator<Storage.StorageDirectory> it = fsImage.getStorage().dirIterator();
            while (it.hasNext()) {
                st = it.next();
                String dir = "" + st.getRoot();
                String type = "" + st.getStorageDirType();
                out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td>Active</td></tr>");
            }
            long storageDirsSize = removedStorageDirs.size();
            int i = 0;
            while ((long)i < storageDirsSize) {
                st = removedStorageDirs.get(i);
                String dir = "" + st.getRoot();
                String type = "" + st.getStorageDirType();
                out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td><span class=\"failed\">Failed</span></td></tr>");
                ++i;
            }
            out.print("</table></div>\n");
        }

        void generateJournalReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
            if (nn.getNamesystem() == null) {
                return;
            }
            FSEditLog log = nn.getFSImage().getEditLog();
            Preconditions.checkArgument(log != null, "no edit log set in %s", nn);
            out.println("<h3> " + (Object)((Object)nn.getRole()) + " Journal Status: </h3>");
            out.println("<b>Current transaction ID:</b> " + nn.getFSImage().getLastAppliedOrWrittenTxId() + "<br/>");
            boolean openForWrite = log.isOpenForWrite();
            out.println("<div class=\"dfstable\">");
            out.println("<table class=\"storage\" title=\"NameNode Journals\">\n<thead><tr><td><b>Journal Manager</b></td><td><b>State</b></td></tr></thead>");
            for (JournalSet.JournalAndStream jas : log.getJournals()) {
                out.print("<tr>");
                out.print("<td>");
                JournalManager manager = jas.getManager();
                if (null != manager) {
                    String[] managers = manager.toString().split(",");
                    for (int i = 0; i < managers.length; ++i) {
                        out.print(managers[i]);
                        if (i < managers.length - 1) {
                            out.print(",");
                        }
                        if ((i + 1) % 3 != 0) continue;
                        out.print("<br/>");
                    }
                    if (jas.isRequired()) {
                        out.print(" [required]");
                    }
                }
                out.print("</td><td>");
                if (jas.isDisabled()) {
                    out.print("<span class=\"failed\">Failed</span>");
                } else if (openForWrite) {
                    EditLogOutputStream elos = jas.getCurrentStream();
                    if (elos != null) {
                        out.println(elos.generateReport());
                    } else {
                        out.println("not currently writing");
                    }
                } else {
                    out.println("open for read");
                }
                out.println("</td></tr>");
            }
            out.println("</table></div>");
        }

        void generateHealthReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
            FSNamesystem fsn = nn.getNamesystem();
            if (fsn == null) {
                return;
            }
            DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            dm.fetchDatanodes(live, dead, true);
            int liveDecommissioned = 0;
            for (DatanodeDescriptor d : live) {
                liveDecommissioned += d.isDecommissioned() ? 1 : 0;
            }
            int deadDecommissioned = 0;
            for (DatanodeDescriptor d : dead) {
                deadDecommissioned += d.isDecommissioned() ? 1 : 0;
            }
            List<DatanodeDescriptor> decommissioning = dm.getDecommissioningNodes();
            this.sorterField = request.getParameter("sorter/field");
            this.sorterOrder = request.getParameter("sorter/order");
            if (this.sorterField == null) {
                this.sorterField = "name";
            }
            if (this.sorterOrder == null) {
                this.sorterOrder = "ASC";
            }
            String port_suffix = null;
            if (live.size() > 0) {
                String name = ((DatanodeDescriptor)live.get(0)).getXferAddr();
                int idx = name.indexOf(58);
                if (idx > 0) {
                    port_suffix = name.substring(idx);
                }
                for (int i = 1; port_suffix != null && i < live.size(); ++i) {
                    if (((DatanodeDescriptor)live.get(i)).getXferAddr().endsWith(port_suffix)) continue;
                    port_suffix = null;
                    break;
                }
            }
            this.counterReset();
            long[] fsnStats = fsn.getStats();
            long total = fsnStats[0];
            long remaining = fsnStats[2];
            long used = fsnStats[1];
            long nonDFS = total - remaining - used;
            nonDFS = nonDFS < 0L ? 0L : nonDFS;
            float percentUsed = DFSUtil.getPercentUsed(used, total);
            float percentRemaining = DFSUtil.getPercentRemaining(remaining, total);
            float median = 0.0f;
            float max = 0.0f;
            float min = 0.0f;
            float dev = 0.0f;
            if (live.size() > 0) {
                float totalDfsUsed = 0.0f;
                float[] usages = new float[live.size()];
                int i = 0;
                for (DatanodeDescriptor dn : live) {
                    usages[i++] = dn.getDfsUsedPercent();
                    totalDfsUsed += dn.getDfsUsedPercent();
                }
                totalDfsUsed /= (float)live.size();
                Arrays.sort(usages);
                median = usages[usages.length / 2];
                max = usages[usages.length - 1];
                min = usages[0];
                for (i = 0; i < usages.length; ++i) {
                    dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
                }
                dev = (float)Math.sqrt(dev / (float)usages.length);
            }
            long bpUsed = fsnStats[6];
            float percentBpUsed = DFSUtil.getPercentUsed(bpUsed, total);
            String underReplicatedBlocks = "";
            if (nn.getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
                underReplicatedBlocks = this.rowTxt() + this.colTxt("Excludes missing blocks.") + "Number of Under-Replicated Blocks" + this.colTxt() + ":" + this.colTxt() + fsn.getBlockManager().getUnderReplicatedNotMissingBlocks();
            }
            out.print("<div class=\"dfstable\"> <table>\n" + this.rowTxt() + this.colTxt() + "Configured Capacity" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(total) + this.rowTxt() + this.colTxt() + "DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(used) + this.rowTxt() + this.colTxt() + "Non DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(nonDFS) + this.rowTxt() + this.colTxt() + "DFS Remaining" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(remaining) + this.rowTxt() + this.colTxt() + "DFS Used%" + this.colTxt() + ":" + this.colTxt() + DFSUtil.percent2String(percentUsed) + this.rowTxt() + this.colTxt() + "DFS Remaining%" + this.colTxt() + ":" + this.colTxt() + DFSUtil.percent2String(percentRemaining) + this.rowTxt() + this.colTxt() + "Block Pool Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(bpUsed) + this.rowTxt() + this.colTxt() + "Block Pool Used%" + this.colTxt() + ":" + this.colTxt() + DFSUtil.percent2String(percentBpUsed) + this.rowTxt() + this.colTxt() + "DataNodes usages" + this.colTxt() + ":" + this.colTxt() + "Min %" + this.colTxt() + "Median %" + this.colTxt() + "Max %" + this.colTxt() + "stdev %" + this.rowTxt() + this.colTxt() + this.colTxt() + this.colTxt() + DFSUtil.percent2String(min) + this.colTxt() + DFSUtil.percent2String(median) + this.colTxt() + DFSUtil.percent2String(max) + this.colTxt() + DFSUtil.percent2String(dev) + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=LIVE\">Live Nodes</a> " + this.colTxt() + ":" + this.colTxt() + live.size() + " (Decommissioned: " + liveDecommissioned + ")" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DEAD\">Dead Nodes</a> " + this.colTxt() + ":" + this.colTxt() + dead.size() + " (Decommissioned: " + deadDecommissioned + ")" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DECOMMISSIONING\">" + "Decommissioning Nodes</a> " + this.colTxt() + ":" + this.colTxt() + decommissioning.size() + underReplicatedBlocks + "</table></div><br>\n");
            if (live.isEmpty() && dead.isEmpty()) {
                out.print("There are no datanodes in the cluster.");
            }
        }

        void generateStartupProgress(JspWriter out, StartupProgress prog) throws IOException {
            StartupProgressView view = prog.createView();
            FormattedWriter fout = new FormattedWriter(out);
            fout.println("<div id=\"startupprogress\">", new Object[0]);
            fout.println("<div><span>Elapsed Time:</span> %s</div>", StringUtils.formatTime(view.getElapsedTime()));
            fout.println("<div><span>Percent Complete:</span> %s</div>", StringUtils.formatPercent(view.getPercentComplete(), 2));
            fout.println("<table>", new Object[0]);
            fout.println("<tr>", new Object[0]);
            fout.println("<th>Phase</th>", new Object[0]);
            fout.println("<th>Completion</th>", new Object[0]);
            fout.println("<th>Elapsed Time</th>", new Object[0]);
            fout.println("</tr>", new Object[0]);
            for (Phase phase : view.getPhases()) {
                Status status = view.getStatus(phase);
                String timeClass = status == Status.PENDING ? "later" : (status == Status.RUNNING ? "current" : "prior");
                fout.println("<tr class=\"phase %s\">", timeClass);
                this.printPhase(fout, view, phase);
                fout.println("</tr>", new Object[0]);
                for (Step step : view.getSteps(phase)) {
                    fout.println("<tr class=\"step %s\">", timeClass);
                    this.printStep(fout, view, phase, step);
                    fout.println("</tr>", new Object[0]);
                }
            }
            fout.println("</table>", new Object[0]);
            fout.println("</div>", new Object[0]);
        }

        private void printPhase(FormattedWriter fout, StartupProgressView view, Phase phase) throws IOException {
            long size;
            StringBuilder phaseLine = new StringBuilder();
            phaseLine.append(phase.getDescription());
            String file = view.getFile(phase);
            if (file != null) {
                phaseLine.append(" ").append(file);
            }
            if ((size = view.getSize(phase)) != Long.MIN_VALUE) {
                phaseLine.append(" (").append(StringUtils.byteDesc(size)).append(")");
            }
            fout.println("<td class=\"startupdesc\">%s</td>", phaseLine.toString());
            fout.println("<td>%s</td>", StringUtils.formatPercent(view.getPercentComplete(phase), 2));
            fout.println("<td>%s</td>", view.getStatus(phase) == Status.PENDING ? "" : StringUtils.formatTime(view.getElapsedTime(phase)));
        }

        private void printStep(FormattedWriter fout, StartupProgressView view, Phase phase, Step step) throws IOException {
            StepType type;
            long size;
            StringBuilder stepLine = new StringBuilder();
            String file = step.getFile();
            if (file != null) {
                stepLine.append(file);
            }
            if ((size = step.getSize()) != Long.MIN_VALUE) {
                stepLine.append(" (").append(StringUtils.byteDesc(size)).append(")");
            }
            if ((type = step.getType()) != null) {
                stepLine.append(" ").append(type.getDescription());
            }
            fout.println("<td class=\"startupdesc\">%s (%d/%d)</td>", stepLine.toString(), view.getCount(phase, step), view.getTotal(phase, step));
            fout.println("<td>%s</td>", StringUtils.formatPercent(view.getPercentComplete(phase), 2));
            fout.println("<td>%s</td>", view.getStatus(phase) == Status.PENDING ? "" : StringUtils.formatTime(view.getElapsedTime(phase)));
        }

        private static class FormattedWriter {
            private final JspWriter out;

            FormattedWriter(JspWriter out) {
                this.out = out;
            }

            void println(String format, Object ... args) throws IOException {
                this.out.println(StringUtils.format(format, args));
            }
        }
    }
}

