/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeJspHelper;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.mortbay.jetty.InclusiveByteRange;

@InterfaceAudience.Private
public class StreamFile
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    public static final String CONTENT_LENGTH = "Content-Length";

    protected DFSClient getDFSClient(HttpServletRequest request) throws IOException, InterruptedException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        ServletContext context = this.getServletContext();
        DataNode datanode = (DataNode)context.getAttribute("datanode");
        return DatanodeJspHelper.getDFSClient(request, datanode, conf, ugi);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DFSClient dfs;
        String path = ServletUtil.getDecodedPath(request, "/streamFile");
        String rawPath = ServletUtil.getRawPath(request, "/streamFile");
        String filename = JspHelper.validatePath(path);
        String rawFilename = JspHelper.validatePath(rawPath);
        if (filename == null) {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.print("Invalid input");
            return;
        }
        Enumeration reqRanges = request.getHeaders("Range");
        if (reqRanges != null && !reqRanges.hasMoreElements()) {
            reqRanges = null;
        }
        try {
            dfs = this.getDFSClient(request);
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
            return;
        }
        DFSInputStream in = null;
        ServletOutputStream out = null;
        try {
            in = dfs.open(filename);
            out = response.getOutputStream();
            long fileLen = in.getFileLength();
            if (reqRanges != null) {
                List ranges = InclusiveByteRange.satisfiableRanges((Enumeration)reqRanges, (long)fileLen);
                StreamFile.sendPartialData(in, out, response, fileLen, ranges);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + rawFilename + "\"");
                response.setContentType("application/octet-stream");
                response.setHeader(CONTENT_LENGTH, "" + fileLen);
                StreamFile.copyFromOffset(in, out, 0L, fileLen);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            dfs.close();
            dfs = null;
        }
        catch (IOException ioe) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response.isCommitted()=" + response.isCommitted(), ioe);
                }
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                IOUtils.cleanup(LOG, out);
                IOUtils.cleanup(LOG, dfs);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        IOUtils.cleanup(LOG, out);
        IOUtils.cleanup(LOG, dfs);
    }

    static void sendPartialData(FSInputStream in, OutputStream out, HttpServletResponse response, long contentLength, List<InclusiveByteRange> ranges) throws IOException {
        if (ranges == null || ranges.size() != 1) {
            response.setContentLength(0);
            response.setStatus(416);
            response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString((long)contentLength));
        } else {
            InclusiveByteRange singleSatisfiableRange = ranges.get(0);
            long singleLength = singleSatisfiableRange.getSize(contentLength);
            response.setStatus(206);
            response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(contentLength));
            StreamFile.copyFromOffset(in, out, singleSatisfiableRange.getFirst(contentLength), singleLength);
        }
    }

    static void copyFromOffset(FSInputStream in, OutputStream out, long offset, long count) throws IOException {
        in.seek(offset);
        IOUtils.copyBytes((InputStream)in, out, count, false);
    }
}

