/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

abstract class AbstractINodeDiff<N extends INode, A extends INodeAttributes, D extends AbstractINodeDiff<N, A, D>>
implements Comparable<Integer> {
    private int snapshotId;
    A snapshotINode;
    private D posteriorDiff;

    AbstractINodeDiff(int snapshotId, A snapshotINode, D posteriorDiff) {
        this.snapshotId = snapshotId;
        this.snapshotINode = snapshotINode;
        this.posteriorDiff = posteriorDiff;
    }

    @Override
    public final int compareTo(Integer that) {
        return Snapshot.ID_INTEGER_COMPARATOR.compare(this.snapshotId, that);
    }

    public final int getSnapshotId() {
        return this.snapshotId;
    }

    final void setSnapshotId(int snapshot) {
        this.snapshotId = snapshot;
    }

    final D getPosterior() {
        return this.posteriorDiff;
    }

    final void setPosterior(D posterior) {
        this.posteriorDiff = posterior;
    }

    void saveSnapshotCopy(A snapshotCopy) {
        Preconditions.checkState(this.snapshotINode == null, "Expected snapshotINode to be null");
        this.snapshotINode = snapshotCopy;
    }

    A getSnapshotINode() {
        AbstractINodeDiff<N, A, D> d = this;
        while (d.snapshotINode == null) {
            if (d.posteriorDiff == null) {
                return null;
            }
            d = d.posteriorDiff;
        }
        return d.snapshotINode;
    }

    abstract Quota.Counts combinePosteriorAndCollectBlocks(N var1, D var2, INode.BlocksMapUpdateInfo var3, List<INode> var4);

    abstract Quota.Counts destroyDiffAndCollectBlocks(N var1, INode.BlocksMapUpdateInfo var2, List<INode> var3);

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getSnapshotId() + " (post=" + (this.posteriorDiff == null ? null : Integer.valueOf(((AbstractINodeDiff)this.posteriorDiff).getSnapshotId())) + ")";
    }
}

