/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Lists;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.flink.hadoop2.shaded.com.google.common.io.LimitInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.io.IOUtils;

final class LsrPBImage {
    private static final Log LOG = LogFactory.getLog(LsrPBImage.class);
    private final Configuration conf;
    private final PrintWriter out;
    private String[] stringTable;
    private final HashMap<Long, FsImageProto.INodeSection.INode> inodes = Maps.newHashMap();
    private final HashMap<Long, long[]> dirmap = Maps.newHashMap();
    private final ArrayList<FsImageProto.INodeReferenceSection.INodeReference> refList = Lists.newArrayList();

    public LsrPBImage(Configuration conf, PrintWriter out) {
        this.conf = conf;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file.getFD());
            ArrayList<FsImageProto.FileSummary.Section> sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            for (FsImageProto.FileSummary.Section s : sections) {
                fin.getChannel().position(s.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, s.getLength())));
                switch (FSImageFormatProtobuf.SectionName.fromString(s.getName())) {
                    case STRING_TABLE: {
                        this.loadStringTable(is);
                        break;
                    }
                    case INODE: {
                        this.loadINodeSection(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        this.loadINodeReferenceSection(is);
                        break;
                    }
                    case INODE_DIR: {
                        this.loadINodeDirectorySection(is);
                        break;
                    }
                }
            }
            this.list("", 16385L);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, fin);
            throw throwable;
        }
        IOUtils.cleanup(null, fin);
    }

    private void list(String parent, long dirId) {
        FsImageProto.INodeSection.INode inode = this.inodes.get(dirId);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Listing directory id " + dirId + " parent '" + parent + "' (INode is " + inode + ")");
        }
        this.listINode(parent.isEmpty() ? "/" : parent, inode);
        long[] children = this.dirmap.get(dirId);
        if (children == null) {
            return;
        }
        String newParent = parent + inode.getName().toStringUtf8() + "/";
        for (long cid : children) {
            this.list(newParent, cid);
        }
    }

    private void listINode(String parent, FsImageProto.INodeSection.INode inode) {
        switch (inode.getType()) {
            case FILE: {
                FsImageProto.INodeSection.INodeFile f = inode.getFile();
                PermissionStatus p = FSImageFormatPBINode.Loader.loadPermission(f.getPermission(), this.stringTable);
                this.out.print(String.format("-%s %2s %8s %10s %10s %10d %s%s\n", p.getPermission().toString(), f.getReplication(), p.getUserName(), p.getGroupName(), f.getModificationTime(), this.getFileSize(f), parent, inode.getName().toStringUtf8()));
                break;
            }
            case DIRECTORY: {
                FsImageProto.INodeSection.INodeDirectory d = inode.getDirectory();
                PermissionStatus p = FSImageFormatPBINode.Loader.loadPermission(d.getPermission(), this.stringTable);
                this.out.print(String.format("d%s  - %8s %10s %10s %10d %s%s\n", p.getPermission().toString(), p.getUserName(), p.getGroupName(), d.getModificationTime(), 0, parent, inode.getName().toStringUtf8()));
                break;
            }
            case SYMLINK: {
                FsImageProto.INodeSection.INodeSymlink d = inode.getSymlink();
                PermissionStatus p = FSImageFormatPBINode.Loader.loadPermission(d.getPermission(), this.stringTable);
                this.out.print(String.format("-%s  - %8s %10s %10s %10d %s%s -> %s\n", p.getPermission().toString(), p.getUserName(), p.getGroupName(), d.getModificationTime(), 0, parent, inode.getName().toStringUtf8(), d.getTarget().toStringUtf8()));
                break;
            }
        }
    }

    private long getFileSize(FsImageProto.INodeSection.INodeFile f) {
        long size = 0L;
        for (HdfsProtos.BlockProto p : f.getBlocksList()) {
            size += p.getNumBytes();
        }
        return size;
    }

    private void loadINodeDirectorySection(InputStream in) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading directory section");
        }
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            int i;
            long[] l = new long[e.getChildrenCount() + e.getRefChildrenCount()];
            for (i = 0; i < e.getChildrenCount(); ++i) {
                l[i] = e.getChildren(i);
            }
            for (i = e.getChildrenCount(); i < l.length; ++i) {
                int refId = e.getRefChildren(i - e.getChildrenCount());
                l[i] = this.refList.get(refId).getReferredId();
            }
            this.dirmap.put(e.getParent(), l);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Loaded directory (parent " + e.getParent() + ") with " + e.getChildrenCount() + " children and " + e.getRefChildrenCount() + " reference children");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + this.dirmap.size() + " directories");
        }
    }

    private void loadINodeReferenceSection(InputStream in) throws IOException {
        FsImageProto.INodeReferenceSection.INodeReference e;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading inode reference section");
        }
        while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom(in)) != null) {
            this.refList.add(e);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Loaded inode reference named '" + e.getName() + "' referring to id " + e.getReferredId() + "");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + this.refList.size() + " inode references");
        }
    }

    private void loadINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + s.getNumInodes() + " inodes in inode section");
        }
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            this.inodes.put(p.getId(), p);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loaded inode id " + p.getId() + " type " + p.getType() + " name '" + p.getName().toStringUtf8() + "'");
            }
            ++i;
        }
    }

    private void loadStringTable(InputStream in) throws IOException {
        FsImageProto.StringTableSection s = FsImageProto.StringTableSection.parseDelimitedFrom(in);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + s.getNumEntry() + " strings in string section");
        }
        this.stringTable = new String[s.getNumEntry() + 1];
        for (int i = 0; i < s.getNumEntry(); ++i) {
            FsImageProto.StringTableSection.Entry e = FsImageProto.StringTableSection.Entry.parseDelimitedFrom(in);
            this.stringTable[e.getId()] = e.getStr();
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Loaded string " + e.getStr());
        }
    }
}

