/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.regex.Pattern;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Splitter;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class StringHelper {
    public static final Joiner SSV_JOINER = Joiner.on(' ');
    public static final Joiner CSV_JOINER = Joiner.on(',');
    public static final Joiner JOINER = Joiner.on("");
    public static final Joiner _JOINER = Joiner.on('_');
    public static final Joiner PATH_JOINER = Joiner.on('/');
    public static final Joiner PATH_ARG_JOINER = Joiner.on("/:");
    public static final Joiner DOT_JOINER = Joiner.on('.');
    public static final Splitter SSV_SPLITTER = Splitter.on(' ').omitEmptyStrings().trimResults();
    public static final Splitter _SPLITTER = Splitter.on('_').trimResults();
    private static final Pattern ABS_URL_RE = Pattern.compile("^(?:\\w+:)?//");

    public static String sjoin(Object ... args) {
        return SSV_JOINER.join(args);
    }

    public static String cjoin(Object ... args) {
        return CSV_JOINER.join(args);
    }

    public static String djoin(Object ... args) {
        return DOT_JOINER.join(args);
    }

    public static String _join(Object ... args) {
        return _JOINER.join(args);
    }

    public static String pjoin(Object ... args) {
        return PATH_JOINER.join(args);
    }

    public static String pajoin(Object ... args) {
        return PATH_ARG_JOINER.join(args);
    }

    public static String join(Object ... args) {
        return JOINER.join(args);
    }

    public static String joins(String sep, Object ... args) {
        return Joiner.on(sep).join(args);
    }

    public static Iterable<String> split(CharSequence s) {
        return SSV_SPLITTER.split(s);
    }

    public static Iterable<String> _split(CharSequence s) {
        return _SPLITTER.split(s);
    }

    public static boolean isAbsUrl(CharSequence url) {
        return ABS_URL_RE.matcher(url).find();
    }

    public static String ujoin(String pathPrefix, String ... args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : args) {
            if (first) {
                first = false;
                if (part.startsWith("#") || StringHelper.isAbsUrl(part)) {
                    sb.append(part);
                    continue;
                }
                StringHelper.uappend(sb, pathPrefix);
                StringHelper.uappend(sb, part);
                continue;
            }
            StringHelper.uappend(sb, part);
        }
        return sb.toString();
    }

    private static void uappend(StringBuilder sb, String part) {
        if (!(sb.length() > 0 && sb.charAt(sb.length() - 1) == '/' || part.startsWith("/"))) {
            sb.append('/');
        }
        sb.append(part);
    }

    public static String percent(double value) {
        return String.format("%.2f", value * 100.0);
    }
}

