/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop2.shaded.com.google.common.cache.Cache;
import org.apache.flink.hadoop2.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.net.unix.DomainSocket;

class DomainSocketFactory {
    private static final Log LOG = BlockReaderLocal.LOG;
    final Cache<String, PathState> pathMap = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public DomainSocketFactory(DFSClient.Conf conf) {
        String feature = conf.shortCircuitLocalReads && !conf.useLegacyBlockReaderLocal ? "The short-circuit local reads feature" : (conf.domainSocketDataTraffic ? "UNIX domain socket data traffic" : null);
        if (feature == null) {
            LOG.debug((Object)"Both short-circuit local reads and UNIX domain socket are disabled.");
        } else {
            if (conf.domainSocketPath.isEmpty()) {
                throw new HadoopIllegalArgumentException(feature + " is enabled but " + "dfs.domain.socket.path" + " is not set.");
            }
            if (DomainSocket.getLoadingFailureReason() != null) {
                LOG.warn((Object)(feature + " cannot be used because " + DomainSocket.getLoadingFailureReason()));
            } else {
                LOG.debug((Object)(feature + " is enabled."));
            }
        }
    }

    public PathInfo getPathInfo(InetSocketAddress addr, DFSClient.Conf conf) {
        if (conf.domainSocketPath.isEmpty()) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!(conf.domainSocketDataTraffic || conf.shortCircuitLocalReads && !conf.useLegacyBlockReaderLocal)) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!DFSClient.isLocalAddress(addr)) {
            return PathInfo.NOT_CONFIGURED;
        }
        String escapedPath = DomainSocket.getEffectivePath(conf.domainSocketPath, addr.getPort());
        PathState status = this.pathMap.getIfPresent(escapedPath);
        if (status == null) {
            return new PathInfo(escapedPath, PathState.VALID);
        }
        return new PathInfo(escapedPath, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainSocket createSocket(PathInfo info, int socketTimeout) {
        Preconditions.checkArgument(info.getPathState() != PathState.UNUSABLE);
        boolean success = false;
        DomainSocket sock = null;
        try {
            sock = DomainSocket.connect(info.getPath());
            sock.setAttribute(4, socketTimeout);
            success = true;
        }
        catch (IOException e) {
            LOG.warn((Object)"error creating DomainSocket", (Throwable)e);
        }
        finally {
            if (!success) {
                if (sock != null) {
                    IOUtils.closeQuietly((Closeable)sock);
                }
                this.pathMap.put(info.getPath(), PathState.UNUSABLE);
                sock = null;
            }
        }
        return sock;
    }

    public void disableShortCircuitForPath(String path) {
        this.pathMap.put(path, PathState.SHORT_CIRCUIT_DISABLED);
    }

    public void disableDomainSocketPath(String path) {
        this.pathMap.put(path, PathState.UNUSABLE);
    }

    public static class PathInfo {
        private static final PathInfo NOT_CONFIGURED = new PathInfo("", PathState.UNUSABLE);
        private final String path;
        private final PathState state;

        PathInfo(String path, PathState state) {
            this.path = path;
            this.state = state;
        }

        public String getPath() {
            return this.path;
        }

        public PathState getPathState() {
            return this.state;
        }

        public String toString() {
            return "PathInfo{path=" + this.path + ", state=" + (Object)((Object)this.state) + "}";
        }
    }

    public static enum PathState {
        UNUSABLE(false, false),
        SHORT_CIRCUIT_DISABLED(true, false),
        VALID(true, true);

        private final boolean usableForDataTransfer;
        private final boolean usableForShortCircuit;

        private PathState(boolean usableForDataTransfer, boolean usableForShortCircuit) {
            this.usableForDataTransfer = usableForDataTransfer;
            this.usableForShortCircuit = usableForShortCircuit;
        }

        public boolean getUsableForDataTransfer() {
            return this.usableForDataTransfer;
        }

        public boolean getUsableForShortCircuit() {
            return this.usableForShortCircuit;
        }
    }
}

