/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Log LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    HAServiceProtocol.HAServiceState state;
    final BPOfferService bpos;
    volatile long lastBlockReport = 0L;
    volatile long lastDeletedReport = 0L;
    boolean resetBlockReportTime = true;
    volatile long lastCacheReport = 0L;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private volatile long lastHeartbeat = 0L;
    private volatile RunningState runningState = RunningState.CONNECTING;
    private final Map<DatanodeStorage, PerStoragePendingIncrementalBR> pendingIncrementalBRperStorage = Maps.newHashMap();
    private volatile boolean sendImmediateIBR = false;
    private volatile boolean shouldServiceRun = true;
    private final DataNode dn;
    private final DNConf dnConf;
    private DatanodeRegistration bpRegistration;

    BPServiceActor(InetSocketAddress nnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.dnConf = this.dn.getDnConf();
    }

    boolean isAlive() {
        if (!this.shouldServiceRun || !this.bpThread.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING || this.runningState == RunningState.CONNECTING;
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug((Object)(this + " received versionRequest response: " + nsInfo));
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            catch (IOException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions(nnVersion, minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion()) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn((Object)ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info((Object)("Reported NameNode version '" + nnVersion + "' does not match " + "DataNode version '" + dnVersion + "' but is within acceptable " + "limits. Note: This is normal during a rolling upgrade."));
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.bpos.verifyAndSetNamespaceInfo(nsInfo);
        this.register();
    }

    void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? Time.now() - (this.dnConf.blockReportInterval - (long)DFSUtil.getRandom().nextInt((int)delay)) : this.lastHeartbeat - this.dnConf.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    void reportBadBlocks(ExtendedBlock block, String storageUuid, StorageType storageType) {
        if (this.bpRegistration == null) {
            return;
        }
        DatanodeInfo[] dnArr = new DatanodeInfo[]{new DatanodeInfo(this.bpRegistration)};
        String[] uuids = new String[]{storageUuid};
        StorageType[] types = new StorageType[]{storageType};
        LocatedBlock[] blocks = new LocatedBlock[]{new LocatedBlock(block, dnArr, uuids, types)};
        try {
            this.bpNamenode.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to report bad block " + block + " to namenode : " + " Exception"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportReceivedDeletedBlocks() throws IOException {
        PerStoragePendingIncrementalBR perStorageMap;
        ArrayList<StorageReceivedDeletedBlocks> reports = new ArrayList<StorageReceivedDeletedBlocks>(this.pendingIncrementalBRperStorage.size());
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            for (Map.Entry<DatanodeStorage, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
                DatanodeStorage storage = entry.getKey();
                perStorageMap = entry.getValue();
                if (perStorageMap.getBlockInfoCount() <= 0) continue;
                ReceivedDeletedBlockInfo[] rdbi = perStorageMap.dequeueBlockInfos();
                reports.add(new StorageReceivedDeletedBlocks(storage, rdbi));
            }
            this.sendImmediateIBR = false;
        }
        if (reports.size() == 0) {
            return;
        }
        boolean success = false;
        try {
            this.bpNamenode.blockReceivedAndDeleted(this.bpRegistration, this.bpos.getBlockPoolId(), reports.toArray(new StorageReceivedDeletedBlocks[reports.size()]));
            success = true;
        }
        finally {
            if (!success) {
                Map<DatanodeStorage, PerStoragePendingIncrementalBR> map2 = this.pendingIncrementalBRperStorage;
                synchronized (map2) {
                    for (StorageReceivedDeletedBlocks report : reports) {
                        perStorageMap = this.pendingIncrementalBRperStorage.get(report.getStorage());
                        perStorageMap.putMissingBlockInfos(report.getBlocks());
                        this.sendImmediateIBR = true;
                    }
                }
            }
        }
    }

    private PerStoragePendingIncrementalBR getIncrementalBRMapForStorage(DatanodeStorage storage) {
        PerStoragePendingIncrementalBR mapForStorage = this.pendingIncrementalBRperStorage.get(storage);
        if (mapForStorage == null) {
            mapForStorage = new PerStoragePendingIncrementalBR();
            this.pendingIncrementalBRperStorage.put(storage, mapForStorage);
        }
        return mapForStorage;
    }

    void addPendingReplicationBlockInfo(ReceivedDeletedBlockInfo bInfo, DatanodeStorage storage) {
        for (Map.Entry<DatanodeStorage, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
            if (entry.getValue().removeBlockInfo(bInfo)) break;
        }
        this.getIncrementalBRMapForStorage(storage).putBlockInfo(bInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeBlockImmediately(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, this.dn.getFSDataset().getStorage(storageUuid));
            this.sendImmediateIBR = true;
            this.pendingIncrementalBRperStorage.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeDeletedBlock(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, this.dn.getFSDataset().getStorage(storageUuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerBlockReportForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastBlockReport = 0L;
            this.lastHeartbeat = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastBlockReport == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerHeartbeatForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastHeartbeat = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastHeartbeat == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerDeletionReportForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastDeletedReport = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastDeletedReport == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    boolean hasPendingIBR() {
        return this.sendImmediateIBR;
    }

    List<DatanodeCommand> blockReport() throws IOException {
        int numReportsSent;
        long startTime = Time.now();
        if (startTime - this.lastBlockReport <= this.dnConf.blockReportInterval) {
            return null;
        }
        ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
        this.reportReceivedDeletedBlocks();
        this.lastDeletedReport = startTime;
        long brCreateStartTime = Time.now();
        Map<DatanodeStorage, BlockListAsLongs> perVolumeBlockLists = this.dn.getFSDataset().getBlockReports(this.bpos.getBlockPoolId());
        int i = 0;
        int totalBlockCount = 0;
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> kvPair : perVolumeBlockLists.entrySet()) {
            BlockListAsLongs blockList = kvPair.getValue();
            reports[i++] = new StorageBlockReport(kvPair.getKey(), blockList.getBlockListAsLongs());
            totalBlockCount += blockList.getNumberOfBlocks();
        }
        long brSendStartTime = Time.now();
        if ((long)totalBlockCount < this.dnConf.blockReportSplitThreshold) {
            numReportsSent = 1;
            DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), reports);
            if (cmd != null) {
                cmds.add(cmd);
            }
        } else {
            numReportsSent = i;
            for (StorageBlockReport report : reports) {
                StorageBlockReport[] singleReport = new StorageBlockReport[]{report};
                DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), singleReport);
                if (cmd == null) continue;
                cmds.add(cmd);
            }
        }
        long brSendCost = Time.now() - brSendStartTime;
        long brCreateCost = brSendStartTime - brCreateStartTime;
        this.dn.getMetrics().addBlockReport(brSendCost);
        LOG.info((Object)("Sent " + numReportsSent + " blockreports " + totalBlockCount + " blocks total. Took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing. " + " Got back commands " + (cmds.size() == 0 ? "none" : Joiner.on("; ").join(cmds))));
        this.scheduleNextBlockReport(startTime);
        return cmds.size() == 0 ? null : cmds;
    }

    private void scheduleNextBlockReport(long previousReportStartTime) {
        if (this.resetBlockReportTime) {
            this.lastBlockReport = previousReportStartTime - (long)DFSUtil.getRandom().nextInt((int)this.dnConf.blockReportInterval);
            this.resetBlockReportTime = false;
        } else {
            this.lastBlockReport += (Time.now() - this.lastBlockReport) / this.dnConf.blockReportInterval * this.dnConf.blockReportInterval;
        }
    }

    DatanodeCommand cacheReport() throws IOException {
        if (this.dn.getFSDataset().getCacheCapacity() == 0L) {
            return null;
        }
        DatanodeCommand cmd = null;
        long startTime = Time.monotonicNow();
        if (startTime - this.lastCacheReport > this.dnConf.cacheReportInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending cacheReport from service actor: " + this));
            }
            this.lastCacheReport = startTime;
            String bpid = this.bpos.getBlockPoolId();
            List<Long> blockIds = this.dn.getFSDataset().getCacheReport(bpid);
            long createTime = Time.monotonicNow();
            cmd = this.bpNamenode.cacheReport(this.bpRegistration, bpid, blockIds);
            long sendTime = Time.monotonicNow();
            long createCost = createTime - startTime;
            long sendCost = sendTime - createTime;
            this.dn.getMetrics().addCacheReport(sendCost);
            LOG.debug((Object)("CacheReport of " + blockIds.size() + " block(s) took " + createCost + " msec to generate and " + sendCost + " msecs for RPC and NN processing"));
        }
        return cmd;
    }

    HeartbeatResponse sendHeartBeat() throws IOException {
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this));
        }
        return this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getXceiverCount(), this.dn.getFSDataset().getNumFailedVolumes());
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread((Runnable)this, this.formatThreadName());
        this.bpThread.setDaemon(true);
        this.bpThread.start();
    }

    private String formatThreadName() {
        List<StorageLocation> dataDirs = DataNode.getStorageLocations(this.dn.getConf());
        return "DataNode: [" + dataDirs.toString() + "] " + " heartbeating to " + this.nnAddr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanup(LOG, this.bpNamenode);
        this.bpos.shutdownActor(this);
    }

    private void handleRollingUpgradeStatus(HeartbeatResponse resp) {
        RollingUpgradeStatus rollingUpgradeStatus = resp.getRollingUpdateStatus();
        if (rollingUpgradeStatus != null && rollingUpgradeStatus.getBlockPoolId().compareTo(this.bpos.getBlockPoolId()) != 0) {
            LOG.error((Object)("Invalid BlockPoolId " + rollingUpgradeStatus.getBlockPoolId() + " in HeartbeatResponse. Expected " + this.bpos.getBlockPoolId()));
        } else {
            this.bpos.signalRollingUpgrade(rollingUpgradeStatus != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerService() throws Exception {
        LOG.info((Object)("For namenode " + this.nnAddr + " using" + " DELETEREPORT_INTERVAL of " + this.dnConf.deleteReportInterval + " msec " + " BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msec" + " CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msec" + " Initial delay: " + this.dnConf.initialBlockReportDelay + "msec" + "; heartBeatInterval=" + this.dnConf.heartBeatInterval));
        while (this.shouldRun()) {
            try {
                List<DatanodeCommand> cmds;
                long startTime = Time.now();
                if (startTime - this.lastHeartbeat >= this.dnConf.heartBeatInterval) {
                    this.lastHeartbeat = startTime;
                    if (!this.dn.areHeartbeatsDisabledForTests()) {
                        HeartbeatResponse resp = this.sendHeartBeat();
                        assert (resp != null);
                        this.dn.getMetrics().addHeartbeat(Time.now() - startTime);
                        this.bpos.updateActorStatesFromHeartbeat(this, resp.getNameNodeHaState());
                        this.state = resp.getNameNodeHaState().getState();
                        if (this.state == HAServiceProtocol.HAServiceState.ACTIVE) {
                            this.handleRollingUpgradeStatus(resp);
                        }
                        long startProcessCommands = Time.now();
                        if (!this.processCommand(resp.getCommands())) continue;
                        long endProcessCommands = Time.now();
                        if (endProcessCommands - startProcessCommands > 2000L) {
                            LOG.info((Object)("Took " + (endProcessCommands - startProcessCommands) + "ms to process " + resp.getCommands().length + " commands from NN"));
                        }
                    }
                }
                if (this.sendImmediateIBR || startTime - this.lastDeletedReport > this.dnConf.deleteReportInterval) {
                    this.reportReceivedDeletedBlocks();
                    this.lastDeletedReport = startTime;
                }
                this.processCommand((cmds = this.blockReport()) == null ? null : cmds.toArray(new DatanodeCommand[cmds.size()]));
                DatanodeCommand cmd = this.cacheReport();
                this.processCommand(new DatanodeCommand[]{cmd});
                if (this.dn.blockScanner != null) {
                    this.dn.blockScanner.addBlockPool(this.bpos.getBlockPoolId());
                }
                long waitTime = this.dnConf.heartBeatInterval - (Time.now() - this.lastHeartbeat);
                Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
                synchronized (map) {
                    if (waitTime > 0L && !this.sendImmediateIBR) {
                        try {
                            this.pendingIncrementalBRperStorage.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)("BPOfferService for " + this + " interrupted"));
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)(this + " is shutting down"), (Throwable)re);
                    this.shouldServiceRun = false;
                    return;
                }
                LOG.warn((Object)"RemoteException in offerService", (Throwable)re);
                try {
                    long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in offerService", (Throwable)e);
            }
        }
    }

    void register() throws IOException {
        this.bpRegistration = this.bpos.createRegistration();
        LOG.info((Object)(this + " beginning handshake with NN"));
        while (this.shouldRun()) {
            try {
                this.bpRegistration = this.bpNamenode.registerDatanode(this.bpRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
        }
        LOG.info((Object)("Block pool " + this + " successfully registered with NN"));
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.scheduleBlockReport(this.dnConf.initialBlockReportDelay);
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)("BPOfferService " + this + " interrupted while " + stateString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.info((Object)(this + " starting to offer service"));
        try {
            while (true) {
                try {
                    this.connectToNNAndHandshake();
                }
                catch (IOException ioe) {
                    this.runningState = RunningState.INIT_FAILED;
                    if (!this.shouldRetryInit()) {
                        this.runningState = RunningState.FAILED;
                        LOG.fatal((Object)("Initialization failed for " + this + ". Exiting. "), (Throwable)ioe);
                        LOG.warn((Object)("Ending block pool service for: " + this));
                        this.cleanUp();
                        return;
                    }
                    LOG.error((Object)("Initialization failed for " + this + " " + ioe.getLocalizedMessage()));
                    this.sleepAndLogInterrupts(5000, "initializing");
                    continue;
                }
                break;
            }
            this.runningState = RunningState.RUNNING;
        }
        catch (Throwable ex) {
            LOG.warn((Object)("Unexpected exception in block pool " + this), ex);
            this.runningState = RunningState.FAILED;
            return;
        }
        finally {
            LOG.warn((Object)("Ending block pool service for: " + this));
            this.cleanUp();
        }
        while (true) {
            if (!this.shouldRun()) {
                this.runningState = RunningState.EXITED;
                return;
            }
            try {
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception in BPOfferService for " + this), (Throwable)ex);
                this.sleepAndLogInterrupts(5000, "offering service");
                continue;
            }
            break;
        }
    }

    private boolean shouldRetryInit() {
        return this.shouldRun() && this.bpos.shouldRetryInit();
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.bpos.processCommandFromActor(cmd, this)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    void trySendErrorReport(int errCode, String errMsg) {
        try {
            this.bpNamenode.errorReport(this.bpRegistration, errCode, errMsg);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error reporting an error to NameNode " + this.nnAddr), (Throwable)e);
        }
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            this.retrieveNamespaceInfo();
            this.register();
        }
    }

    private static class PerStoragePendingIncrementalBR {
        private final Map<Long, ReceivedDeletedBlockInfo> pendingIncrementalBR = Maps.newHashMap();

        private PerStoragePendingIncrementalBR() {
        }

        int getBlockInfoCount() {
            return this.pendingIncrementalBR.size();
        }

        ReceivedDeletedBlockInfo[] dequeueBlockInfos() {
            ReceivedDeletedBlockInfo[] blockInfos = this.pendingIncrementalBR.values().toArray(new ReceivedDeletedBlockInfo[this.getBlockInfoCount()]);
            this.pendingIncrementalBR.clear();
            return blockInfos;
        }

        int putMissingBlockInfos(ReceivedDeletedBlockInfo[] blockArray) {
            int blocksPut = 0;
            for (ReceivedDeletedBlockInfo rdbi : blockArray) {
                if (this.pendingIncrementalBR.containsKey(rdbi.getBlock().getBlockId())) continue;
                this.pendingIncrementalBR.put(rdbi.getBlock().getBlockId(), rdbi);
                ++blocksPut;
            }
            return blocksPut;
        }

        void putBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            this.pendingIncrementalBR.put(blockInfo.getBlock().getBlockId(), blockInfo);
        }

        boolean removeBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            return this.pendingIncrementalBR.remove(blockInfo.getBlock().getBlockId()) != null;
        }
    }

    static enum RunningState {
        CONNECTING,
        INIT_FAILED,
        RUNNING,
        EXITED,
        FAILED;

    }
}

