/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

class FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final UserGroupInformation ugi;
    private final String user;
    private final Set<String> groups;
    private final boolean isSuper;

    private String toAccessControlString(INode inode, int snapshotId, FsAction access, FsPermission mode) {
        return this.toAccessControlString(inode, snapshotId, access, mode, null);
    }

    private String toAccessControlString(INode inode, int snapshotId, FsAction access, FsPermission mode, List<AclEntry> featureEntries) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.user).append(", ").append("access=").append((Object)access).append(", ").append("inode=\"").append(inode.getFullPathName()).append("\":").append(inode.getUserName(snapshotId)).append(':').append(inode.getGroupName(snapshotId)).append(':').append(inode.isDirectory() ? (char)'d' : '-').append(mode);
        if (featureEntries != null) {
            sb.append(':').append(StringUtils.join((CharSequence)",", featureEntries));
        }
        return sb.toString();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi) {
        this.ugi = callerUgi;
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.ugi.getGroupNames()));
        this.groups = Collections.unmodifiableSet(s);
        this.user = this.ugi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuper) {
            throw new AccessControlException("Access denied for user " + this.user + ". Superuser privilege is required");
        }
    }

    void checkPermission(String path, INodeDirectory root, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        int ancestorIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + (Object)((Object)ancestorAccess) + ", parentAccess=" + (Object)((Object)parentAccess) + ", access=" + (Object)((Object)access) + ", subAccess=" + (Object)((Object)subAccess) + ", resolveLink=" + resolveLink));
        }
        INodesInPath inodesInPath = root.getINodesInPath(path, resolveLink);
        int snapshotId = inodesInPath.getPathSnapshotId();
        INode[] inodes = inodesInPath.getINodes();
        for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
        }
        this.checkTraverse(inodes, ancestorIndex, snapshotId);
        INode last = inodes[inodes.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodes.length > 1 && last != null) {
            this.checkStickyBit(inodes[inodes.length - 2], last, snapshotId);
        }
        if (ancestorAccess != null && inodes.length > 1) {
            this.check(inodes, ancestorIndex, snapshotId, ancestorAccess);
        }
        if (parentAccess != null && inodes.length > 1) {
            this.check(inodes, inodes.length - 2, snapshotId, parentAccess);
        }
        if (access != null) {
            this.check(last, snapshotId, access);
        }
        if (subAccess != null) {
            this.checkSubAccess(last, snapshotId, subAccess);
        }
        if (doCheckOwner) {
            this.checkOwner(last, snapshotId);
        }
    }

    private void checkOwner(INode inode, int snapshotId) throws AccessControlException {
        if (inode != null && this.user.equals(inode.getUserName(snapshotId))) {
            return;
        }
        throw new AccessControlException("Permission denied");
    }

    private void checkTraverse(INode[] inodes, int last, int snapshotId) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], snapshotId, FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(INode inode, int snapshotId, FsAction access) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            this.check(d, snapshotId, access);
            for (INode child : d.getChildrenList(snapshotId)) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(INode[] inodes, int i, int snapshotId, FsAction access) throws AccessControlException {
        this.check(i >= 0 ? inodes[i] : null, snapshotId, access);
    }

    private void check(INode inode, int snapshotId, FsAction access) throws AccessControlException {
        ImmutableList<AclEntry> featureEntries;
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission(snapshotId);
        AclFeature aclFeature = inode.getAclFeature(snapshotId);
        if (aclFeature != null && ((AclEntry)(featureEntries = aclFeature.getEntries()).get(0)).getScope() == AclEntryScope.ACCESS) {
            this.checkAccessAcl(inode, snapshotId, access, mode, featureEntries);
            return;
        }
        this.checkFsPermission(inode, snapshotId, access, mode);
    }

    private void checkFsPermission(INode inode, int snapshotId, FsAction access, FsPermission mode) throws AccessControlException {
        if (this.user.equals(inode.getUserName(snapshotId)) ? mode.getUserAction().implies(access) : (this.groups.contains(inode.getGroupName(snapshotId)) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, snapshotId, access, mode));
    }

    private void checkAccessAcl(INode inode, int snapshotId, FsAction access, FsPermission mode, List<AclEntry> featureEntries) throws AccessControlException {
        boolean foundMatch = false;
        if (this.user.equals(inode.getUserName(snapshotId))) {
            if (mode.getUserAction().implies(access)) {
                return;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            for (AclEntry entry : featureEntries) {
                String group;
                if (entry.getScope() == AclEntryScope.DEFAULT) break;
                AclEntryType type = entry.getType();
                String name = entry.getName();
                if (type == AclEntryType.USER) {
                    if (!this.user.equals(name)) continue;
                    FsAction masked = entry.getPermission().and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return;
                    }
                    foundMatch = true;
                    continue;
                }
                if (type != AclEntryType.GROUP || !this.groups.contains(group = name == null ? inode.getGroupName(snapshotId) : name)) continue;
                FsAction masked = entry.getPermission().and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return;
                }
                foundMatch = true;
            }
        }
        if (!foundMatch && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, snapshotId, access, mode, featureEntries));
    }

    private void checkStickyBit(INode parent, INode inode, int snapshotId) throws AccessControlException {
        if (!parent.getFsPermission(snapshotId).getStickyBit()) {
            return;
        }
        if (parent.getUserName(snapshotId).equals(this.user)) {
            return;
        }
        if (inode.getUserName(snapshotId).equals(this.user)) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + this.user + ", inode=" + inode);
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.user.equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.groups.contains(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.user + " does not have " + access.toString() + " permissions.");
    }
}

