/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.IOException;
import java.net.InetAddress;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ServiceAuthorizationManager {
    private static final String HADOOP_POLICY_FILE = "hadoop-policy.xml";
    private Map<Class<?>, AccessControlList> protocolToAcl = new IdentityHashMap();
    @Deprecated
    public static final String SERVICE_AUTHORIZATION_CONFIG = "hadoop.security.authorization";
    public static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + ServiceAuthorizationManager.class.getName()));
    private static final String AUTHZ_SUCCESSFUL_FOR = "Authorization successful for ";
    private static final String AUTHZ_FAILED_FOR = "Authorization failed for ";

    public void authorize(UserGroupInformation user, Class<?> protocol, Configuration conf, InetAddress addr) throws AuthorizationException {
        String clientKey;
        AccessControlList acl = this.protocolToAcl.get(protocol);
        if (acl == null) {
            throw new AuthorizationException("Protocol " + protocol + " is not known.");
        }
        KerberosInfo krbInfo = SecurityUtil.getKerberosInfo(protocol, conf);
        String clientPrincipal = null;
        if (krbInfo != null && (clientKey = krbInfo.clientPrincipal()) != null && !clientKey.isEmpty()) {
            try {
                clientPrincipal = SecurityUtil.getServerPrincipal(conf.get(clientKey), addr);
            }
            catch (IOException e) {
                throw (AuthorizationException)new AuthorizationException("Can't figure out Kerberos principal name for connection from " + addr + " for user=" + user + " protocol=" + protocol).initCause(e);
            }
        }
        if (clientPrincipal != null && !clientPrincipal.equals(user.getUserName()) || !acl.isUserAllowed(user)) {
            AUDITLOG.warn((Object)(AUTHZ_FAILED_FOR + user + " for protocol=" + protocol + ", expected client Kerberos principal is " + clientPrincipal));
            throw new AuthorizationException("User " + user + " is not authorized for protocol " + protocol + ", expected client Kerberos principal is " + clientPrincipal);
        }
        AUDITLOG.info((Object)(AUTHZ_SUCCESSFUL_FOR + user + " for protocol=" + protocol));
    }

    public synchronized void refresh(Configuration conf, PolicyProvider provider) {
        String policyFile = System.getProperty("hadoop.policy.file", HADOOP_POLICY_FILE);
        Configuration policyConf = new Configuration(conf);
        policyConf.addResource(policyFile);
        this.refreshWithLoadedConfiguration(policyConf, provider);
    }

    @InterfaceAudience.Private
    public synchronized void refreshWithLoadedConfiguration(Configuration conf, PolicyProvider provider) {
        IdentityHashMap newAcls = new IdentityHashMap();
        Service[] services = provider.getServices();
        if (services != null) {
            for (Service service : services) {
                AccessControlList acl = new AccessControlList(conf.get(service.getServiceKey(), "*"));
                newAcls.put(service.getProtocol(), acl);
            }
        }
        this.protocolToAcl = newAcls;
    }

    @VisibleForTesting
    public Set<Class<?>> getProtocolsWithAcls() {
        return this.protocolToAcl.keySet();
    }

    @VisibleForTesting
    public AccessControlList getProtocolsAcls(Class<?> className) {
        return this.protocolToAcl.get(className);
    }
}

