/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps;

import org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.flink.hadoop.shaded.org.apache.curator.utils.EnsurePath;
import org.apache.flink.hadoop.shaded.org.apache.curator.utils.PathUtils;
import org.apache.flink.hadoop.shaded.org.apache.curator.utils.ZKPaths;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final EnsurePath ensurePath;

    NamespaceImpl(CuratorFrameworkImpl client, String namespace) {
        if (namespace != null) {
            try {
                PathUtils.validatePath("/" + namespace);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace);
            }
        }
        this.client = client;
        this.namespace = namespace;
        this.ensurePath = namespace != null ? new EnsurePath(ZKPaths.makePath("/", namespace)) : null;
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String path) {
        String namespacePath;
        if (this.namespace != null && path != null && path.startsWith(namespacePath = ZKPaths.makePath(this.namespace, null))) {
            path = path.length() > namespacePath.length() ? path.substring(namespacePath.length()) : "/";
        }
        return path;
    }

    String fixForNamespace(String path, boolean isSequential) {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client.getZookeeperClient());
            }
            catch (Exception e) {
                this.client.logError("Ensure path threw exception", e);
            }
        }
        return ZKPaths.fixForNamespace(this.namespace, path, isSequential);
    }

    EnsurePath newNamespaceAwareEnsurePath(String path) {
        return new EnsurePath(this.fixForNamespace(path, false), this.client.getAclProvider());
    }
}

