/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetricsServlet
extends HttpServlet {
    Map<String, Map<String, List<TagsMetricsPair>>> makeMap(Collection<MetricsContext> contexts) throws IOException {
        TreeMap<String, Map<String, List<TagsMetricsPair>>> map = new TreeMap<String, Map<String, List<TagsMetricsPair>>>();
        for (MetricsContext context : contexts) {
            TreeMap records = new TreeMap();
            map.put(context.getContextName(), records);
            for (Map.Entry<String, Collection<OutputRecord>> r : context.getAllRecords().entrySet()) {
                ArrayList<TagsMetricsPair> metricsAndTags = new ArrayList<TagsMetricsPair>();
                records.put(r.getKey(), metricsAndTags);
                for (OutputRecord outputRecord : r.getValue()) {
                    AbstractMetricsContext.TagMap tagMap = outputRecord.getTagsCopy();
                    AbstractMetricsContext.MetricMap metricMap = outputRecord.getMetricsCopy();
                    metricsAndTags.add(new TagsMetricsPair(tagMap, metricMap));
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer2.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            return;
        }
        String format = request.getParameter("format");
        Collection<MetricsContext> allContexts = ContextFactory.getFactory().getAllContexts();
        if ("json".equals(format)) {
            response.setContentType("application/json; charset=utf-8");
            try (PrintWriter out = response.getWriter();){
                out.print(new JSON().toJSON(this.makeMap(allContexts)));
            }
        }
        try (PrintWriter out = response.getWriter();){
            this.printMap(out, this.makeMap(allContexts));
        }
    }

    void printMap(PrintWriter out, Map<String, Map<String, List<TagsMetricsPair>>> map) {
        for (Map.Entry<String, Map<String, List<TagsMetricsPair>>> context : map.entrySet()) {
            out.print(context.getKey());
            out.print("\n");
            for (Map.Entry<String, List<TagsMetricsPair>> record : context.getValue().entrySet()) {
                this.indent(out, 1);
                out.print(record.getKey());
                out.print("\n");
                for (TagsMetricsPair pair : record.getValue()) {
                    this.indent(out, 2);
                    out.print("{");
                    boolean first = true;
                    for (Map.Entry tagValue : pair.tagMap.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            out.print(",");
                        }
                        out.print((String)tagValue.getKey());
                        out.print("=");
                        out.print(tagValue.getValue().toString());
                    }
                    out.print("}:\n");
                    for (Map.Entry metricValue : pair.metricMap.entrySet()) {
                        this.indent(out, 3);
                        out.print((String)metricValue.getKey());
                        out.print("=");
                        out.print(((Number)metricValue.getValue()).toString());
                        out.print("\n");
                    }
                }
            }
        }
    }

    private void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append("  ");
        }
    }

    static class TagsMetricsPair
    implements JSON.Convertible {
        final AbstractMetricsContext.TagMap tagMap;
        final AbstractMetricsContext.MetricMap metricMap;

        public TagsMetricsPair(AbstractMetricsContext.TagMap tagMap, AbstractMetricsContext.MetricMap metricMap) {
            this.tagMap = tagMap;
            this.metricMap = metricMap;
        }

        public void fromJSON(Map map) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            out.add((Object)new Object[]{this.tagMap, this.metricMap});
        }
    }
}

