/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContainerTokenIdentifier
extends TokenIdentifier {
    private static Log LOG = LogFactory.getLog(ContainerTokenIdentifier.class);
    public static final Text KIND = new Text("ContainerToken");
    private YarnSecurityTokenProtos.ContainerTokenIdentifierProto proto;

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime) {
        this(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null);
    }

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext) {
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.newBuilder();
        if (containerID != null) {
            builder.setContainerId(((ContainerIdPBImpl)containerID).getProto());
        }
        builder.setNmHostAddr(hostName);
        builder.setAppSubmitter(appSubmitter);
        if (r != null) {
            builder.setResource(((ResourcePBImpl)r).getProto());
        }
        builder.setExpiryTimeStamp(expiryTimeStamp);
        builder.setMasterKeyId(masterKeyId);
        builder.setRmIdentifier(rmIdentifier);
        if (priority != null) {
            builder.setPriority(((PriorityPBImpl)priority).getProto());
        }
        builder.setCreationTime(creationTime);
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        this.proto = builder.build();
    }

    public ContainerTokenIdentifier() {
    }

    public ContainerId getContainerID() {
        if (!this.proto.hasContainerId()) {
            return null;
        }
        return new ContainerIdPBImpl(this.proto.getContainerId());
    }

    public String getApplicationSubmitter() {
        return this.proto.getAppSubmitter();
    }

    public String getNmHostAddress() {
        return this.proto.getNmHostAddr();
    }

    public Resource getResource() {
        if (!this.proto.hasResource()) {
            return null;
        }
        return new ResourcePBImpl(this.proto.getResource());
    }

    public long getExpiryTimeStamp() {
        return this.proto.getExpiryTimeStamp();
    }

    public int getMasterKeyId() {
        return this.proto.getMasterKeyId();
    }

    public Priority getPriority() {
        if (!this.proto.hasPriority()) {
            return null;
        }
        return new PriorityPBImpl(this.proto.getPriority());
    }

    public long getCreationTime() {
        return this.proto.getCreationTime();
    }

    public long getRMIdentifier() {
        return this.proto.getRmIdentifier();
    }

    public YarnSecurityTokenProtos.ContainerTokenIdentifierProto getProto() {
        return this.proto;
    }

    public LogAggregationContext getLogAggregationContext() {
        if (!this.proto.hasLogAggregationContext()) {
            return null;
        }
        return new LogAggregationContextPBImpl(this.proto.getLogAggregationContext());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        LOG.debug("Writing ContainerTokenIdentifier to RPC layer: " + this);
        out.write(this.proto.toByteArray());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.proto = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.parseFrom((DataInputStream)in);
    }

    @Override
    public Text getKind() {
        return KIND;
    }

    @Override
    public UserGroupInformation getUser() {
        String containerId = null;
        if (this.proto.hasContainerId()) {
            containerId = new ContainerIdPBImpl(this.proto.getContainerId()).toString();
        }
        return UserGroupInformation.createRemoteUser(containerId);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerTokenIdentifier)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND;
        }
    }
}

