/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>> {
    private static final long serialVersionUID = 1L;
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();

    protected IndexedStringListSerializer() {
        super(List.class);
    }

    public IndexedStringListSerializer(IndexedStringListSerializer src, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, ser, unwrapSingle);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        return new IndexedStringListSerializer(this, ser, unwrapSingle);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(List<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this._serializeUnwrapped(value, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        if (this._serializer == null) {
            this.serializeContents(value, gen, provider, len);
        } else {
            this.serializeUsingCustom(value, gen, provider, len);
        }
        gen.writeEndArray();
    }

    private final void _serializeUnwrapped(List<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializer == null) {
            this.serializeContents(value, gen, provider, 1);
        } else {
            this.serializeUsingCustom(value, gen, provider, 1);
        }
    }

    @Override
    public void serializeWithType(List<String> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        int len = value.size();
        typeSer.writeTypePrefixForArray(value, gen);
        if (this._serializer == null) {
            this.serializeContents(value, gen, provider, len);
        } else {
            this.serializeUsingCustom(value, gen, provider, len);
        }
        typeSer.writeTypeSuffixForArray(value, gen);
    }

    private final void serializeContents(List<String> value, JsonGenerator gen, SerializerProvider provider, int len) throws IOException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    provider.defaultSerializeNull(gen);
                    continue;
                }
                gen.writeString(str);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }

    private final void serializeUsingCustom(List<String> value, JsonGenerator gen, SerializerProvider provider, int len) throws IOException {
        int i = 0;
        try {
            JsonSerializer ser = this._serializer;
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    provider.defaultSerializeNull(gen);
                    continue;
                }
                ser.serialize(str, gen, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }
}

