/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.state.changelog.AbstractChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.StateChangeLoggingIterator;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.ThrowingConsumer;

class ChangelogMapState<K, N, UK, UV>
extends AbstractChangelogState<K, N, Map<UK, UV>, InternalMapState<K, N, UK, UV>>
implements InternalMapState<K, N, UK, UV> {
    private final InternalKeyContext<K> keyContext;

    ChangelogMapState(InternalMapState<K, N, UK, UV> delegatedState, KvStateChangeLogger<Map<UK, UV>, N> changeLogger, InternalKeyContext<K> keyContext) {
        super(delegatedState, changeLogger);
        this.keyContext = keyContext;
    }

    private Map.Entry<UK, UV> loggingMapEntry(final Map.Entry<UK, UV> entry, final KvStateChangeLogger<Map<UK, UV>, N> changeLogger, final N ns) {
        return new Map.Entry<UK, UV>(){

            @Override
            public UK getKey() {
                return entry.getKey();
            }

            @Override
            public UV getValue() {
                return entry.getValue();
            }

            @Override
            public UV setValue(UV value) {
                Object oldValue = entry.setValue(value);
                try {
                    changeLogger.valueElementAddedOrUpdated((ThrowingConsumer<DataOutputView, IOException>)ChangelogMapState.this.getWriter(entry.getKey(), entry.getValue()), ns);
                }
                catch (IOException e) {
                    ExceptionUtils.rethrow((Throwable)e);
                }
                return oldValue;
            }
        };
    }

    public UV get(UK key) throws Exception {
        return (UV)((InternalMapState)this.delegatedState).get(key);
    }

    public void put(UK key, UV value) throws Exception {
        ((InternalMapState)this.delegatedState).put(key, value);
        this.changeLogger.valueElementAddedOrUpdated(this.getWriter(key, value), this.getCurrentNamespace());
    }

    public void putAll(Map<UK, UV> map) throws Exception {
        ((InternalMapState)this.delegatedState).putAll(map);
        this.changeLogger.valueAdded(map, this.getCurrentNamespace());
    }

    public void remove(UK key) throws Exception {
        ((InternalMapState)this.delegatedState).remove(key);
        this.changeLogger.valueElementRemoved((ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)out -> this.serializeKey(key, (DataOutputView)out)), this.getCurrentNamespace());
    }

    public boolean contains(UK key) throws Exception {
        return ((InternalMapState)this.delegatedState).contains(key);
    }

    public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
        Iterator iterator = ((InternalMapState)this.delegatedState).iterator();
        return () -> this.getEntryIterator(iterator);
    }

    private Iterator<Map.Entry<UK, UV>> getEntryIterator(final Iterator<Map.Entry<UK, UV>> iterator) {
        final Object currentNamespace = this.getCurrentNamespace();
        return StateChangeLoggingIterator.create(CloseableIterator.adapterForIterator((Iterator)new Iterator<Map.Entry<UK, UV>>(){

            @Override
            public Map.Entry<UK, UV> next() {
                return ChangelogMapState.this.loggingMapEntry((Map.Entry)iterator.next(), ChangelogMapState.this.changeLogger, currentNamespace);
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        }), this.changeLogger, (entry, out) -> this.serializeKey((UK)entry.getKey(), (DataOutputView)out), currentNamespace);
    }

    public Iterable<UK> keys() throws Exception {
        Iterable iterable = ((InternalMapState)this.delegatedState).keys();
        return () -> StateChangeLoggingIterator.create(CloseableIterator.adapterForIterator(iterable.iterator()), this.changeLogger, this::serializeKey, this.getCurrentNamespace());
    }

    public Iterable<UV> values() throws Exception {
        final Iterator<Map.Entry<UK, UV>> iterator = this.entries().iterator();
        return () -> new Iterator<UV>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public UV next() {
                return ((Map.Entry)iterator.next()).getValue();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
        return this.getEntryIterator(((InternalMapState)this.delegatedState).iterator());
    }

    public boolean isEmpty() throws Exception {
        return ((InternalMapState)this.delegatedState).isEmpty();
    }

    public void clear() {
        ((InternalMapState)this.delegatedState).clear();
        try {
            this.changeLogger.valueCleared(this.getCurrentNamespace());
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void serializeValue(UV value, DataOutputView out) throws IOException {
        this.getMapSerializer().getValueSerializer().serialize(value, out);
    }

    private void serializeKey(UK key, DataOutputView out) throws IOException {
        this.getMapSerializer().getKeySerializer().serialize(key, out);
    }

    private ThrowingConsumer<DataOutputView, IOException> getWriter(UK key, UV value) {
        return out -> {
            this.serializeKey(key, (DataOutputView)out);
            this.serializeValue(value, (DataOutputView)out);
        };
    }

    private MapSerializer<UK, UV> getMapSerializer() {
        return (MapSerializer)this.getValueSerializer();
    }

    static <UK, UV, K, N, SV, S extends State, IS extends S> IS create(InternalKvState<K, N, SV> mapState, KvStateChangeLogger<SV, N> changeLogger, InternalKeyContext<K> keyContext) {
        return (IS)new ChangelogMapState<K, N, UK, UV>((InternalMapState)mapState, changeLogger, keyContext);
    }

    @Override
    public StateChangeApplier getChangeApplier(ChangelogApplierFactory factory) {
        return factory.forMap((InternalMapState)this.delegatedState, this.keyContext);
    }
}

